/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.papmanagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.distribution.DistributionConfiguration;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManagerException;
import org.glite.authz.pap.repository.dao.DAOFactory;
import org.glite.authz.pap.repository.dao.PapDAO;
import org.glite.authz.pap.repository.exceptions.AlreadyExistsException;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapManager {
    private static PapManager instance = null;
    private static final Logger log = LoggerFactory.getLogger(PapManager.class);
    private String[] configurationPapOrdering;
    private DistributionConfiguration distributionConfiguration;
    private PapDAO papDAO = DAOFactory.getDAOFactory().getPapDAO();

    private PapManager() {
        this.createDefaultPapIfNotExists();
        this.distributionConfiguration = DistributionConfiguration.getInstance();
        this.configurationPapOrdering = this.distributionConfiguration.getPapOrdering();
        this.synchronizeRepositoryWithConfiguration();
    }

    public static PapManager getInstance() {
        if (instance == null) {
            throw new PapManagerException("Please initialize configuration before calling the instance method!");
        }
        return instance;
    }

    public static void initialize() {
        if (instance == null) {
            instance = new PapManager();
        }
    }

    public void addPap(Pap pap) {
        String papAlias = pap.getAlias();
        if ("default".equals(papAlias)) {
            throw new PapManagerException("Forbidden alias: " + papAlias);
        }
        if (this.exists(papAlias)) {
            throw new AlreadyExistsException("pap \"" + papAlias + "\" already exists");
        }
        this.distributionConfiguration.savePap(pap);
        this.papDAO.store(pap);
        PapContainer papContainer = new PapContainer(pap);
        papContainer.createRootPolicySet();
    }

    public void deletePap(String papAlias) {
        if ("default".equals(papAlias)) {
            throw new PapManagerException("Deleting the default pap is not allowed");
        }
        this.distributionConfiguration.removePap(papAlias);
        this.papDAO.delete(papAlias);
        this.configurationPapOrdering = this.distributionConfiguration.getPapOrdering();
    }

    public boolean exists(String papAlias) {
        return this.papDAO.exists(papAlias);
    }

    public List<Pap> getAllPaps() {
        return this.getPapList();
    }

    public List<Pap> getLocalPaps() {
        LinkedList<Pap> resultList = new LinkedList<Pap>();
        for (Pap pap : this.getPapList()) {
            if (!pap.isLocal()) continue;
            resultList.add(pap);
        }
        return resultList;
    }

    public List<Pap> getRemotePaps() {
        LinkedList<Pap> remotePapList = new LinkedList<Pap>();
        for (Pap pap : this.getPapList()) {
            if (!pap.isRemote()) continue;
            remotePapList.add(pap);
        }
        return remotePapList;
    }

    public Pap getPap(String papAlias) {
        return this.papDAO.get(papAlias);
    }

    public PapContainer getPapContainer(String papAlias) {
        return new PapContainer(this.getPap(papAlias));
    }

    public String[] getPapOrdering() {
        return this.configurationPapOrdering;
    }

    public List<Pap> getPublicPaps() {
        LinkedList<Pap> resultList = new LinkedList<Pap>();
        for (Pap pap : this.getPapList()) {
            if (!pap.isVisibilityPublic()) continue;
            resultList.add(pap);
        }
        return resultList;
    }

    public void setPapOrdering(String[] aliasArray) {
        this.distributionConfiguration.savePapOrdering(aliasArray);
        this.configurationPapOrdering = this.distributionConfiguration.getPapOrdering();
    }

    public void updatePap(Pap newPap) {
        if (newPap == null) {
            throw new PapManagerException("pap cannot be null");
        }
        String alias = newPap.getAlias();
        if ("default".equals(alias)) {
            this.updateDefaultPap(newPap);
            return;
        }
        Pap oldPap = this.papDAO.get(alias);
        newPap.setId(oldPap.getId());
        this.distributionConfiguration.savePap(newPap);
        this.papDAO.update(newPap);
    }

    private List<String> buildOrderedAliasList() {
        int i;
        int configurationArraySize = this.configurationPapOrdering.length;
        List<String> repositoryAliasList = this.papDAO.getAliasList();
        if (configurationArraySize > repositoryAliasList.size()) {
            throw new PapManagerException("BUG: configuration contains more paps than the repository");
        }
        int defaultPapAliasIdx = repositoryAliasList.indexOf("default");
        if (defaultPapAliasIdx == -1) {
            throw new PapManagerException("BUG: default pap does not exist in the repository");
        }
        LinkedList<String> configurationAliasOrderedList = new LinkedList<String>();
        if (Utils.indexOf("default", this.configurationPapOrdering) == -1) {
            configurationAliasOrderedList.add("default");
        }
        for (i = 0; i < configurationArraySize; ++i) {
            configurationAliasOrderedList.add(this.configurationPapOrdering[i]);
        }
        for (i = 0; i < configurationAliasOrderedList.size(); ++i) {
            String alias = (String)configurationAliasOrderedList.get(i);
            int aliasIndex = repositoryAliasList.indexOf(alias);
            if (aliasIndex == -1) {
                throw new PapManagerException("BUG: initialization error. pap defined in the configuration is not in the repository");
            }
            Collections.swap(repositoryAliasList, aliasIndex, i);
        }
        return repositoryAliasList;
    }

    private void createDefaultPapIfNotExists() {
        if (!this.papDAO.exists("default")) {
            Pap defaultPap = Pap.makeDefaultPAP();
            this.papDAO.store(defaultPap);
        } else {
            Pap defaultPap = this.papDAO.get("default");
        }
        PapContainer defaultPapContainer = this.getPapContainer("default");
        if (defaultPapContainer.hasPolicySet(defaultPapContainer.getRootPolicySetId())) {
            return;
        }
        defaultPapContainer.createRootPolicySet();
    }

    private List<Pap> getPapList() {
        List<String> aliasOrderedList = this.buildOrderedAliasList();
        ArrayList<Pap> papList = new ArrayList<Pap>(aliasOrderedList.size());
        for (String alias : aliasOrderedList) {
            papList.add(this.papDAO.get(alias));
        }
        return papList;
    }

    private void synchronizeRepositoryWithConfiguration() {
        List<Pap> papListFromConfiguration = DistributionConfiguration.getInstance().getPapList();
        if (papListFromConfiguration.isEmpty()) {
            log.info("No remote paps has been defined");
        }
        for (Pap papFromConfiguration : papListFromConfiguration) {
            try {
                String papAlias = papFromConfiguration.getAlias();
                Pap papFromRepository = this.papDAO.get(papAlias);
                if (papFromConfiguration.equals(papFromRepository)) continue;
                log.info("Settings for pap \"" + papAlias + "\" has been updated. Invalidating cache");
                this.papDAO.delete(papAlias);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            this.papDAO.store(papFromConfiguration);
            PapContainer papContainer = new PapContainer(papFromConfiguration);
            papContainer.createRootPolicySet();
        }
        for (String alias : this.papDAO.getAliasList()) {
            if (alias.equals("default")) continue;
            boolean notFoundInConfiguration = true;
            for (Pap papFromConfiguration : papListFromConfiguration) {
                if (!alias.equals(papFromConfiguration.getAlias())) continue;
                notFoundInConfiguration = false;
                break;
            }
            if (!notFoundInConfiguration) continue;
            this.papDAO.delete(alias);
            log.info("Removed pap \"" + alias + "\" from the repository because it hasn't been found in the configuration file.");
        }
    }

    private void updateDefaultPap(Pap newDefaultPap) {
        if (!"default".equals(newDefaultPap.getAlias())) {
            throw new RepositoryException("Invalid alias for default pap. Cannot perform updateDefaultPap request.");
        }
        Pap oldDefaultPap = this.getPap("default");
        newDefaultPap.setId(oldDefaultPap.getId());
        this.papDAO.update(newDefaultPap);
    }
}

