/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.papmanagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.repository.dao.DAOFactory;
import org.glite.authz.pap.repository.dao.PolicyDAO;
import org.glite.authz.pap.repository.dao.PolicySetDAO;
import org.glite.authz.pap.repository.exceptions.AlreadyExistsException;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapContainer {
    private static final Logger log = LoggerFactory.getLogger(PapContainer.class);
    private static final Object notificationLock = new Object();
    private final Pap pap;
    private final String papId;
    private final PolicyDAO policyDAO;
    private final PolicySetDAO policySetDAO;
    private final String rootPolicySetId;

    public PapContainer(Pap pap) {
        this.pap = pap;
        this.rootPolicySetId = this.papId = pap.getId();
        this.policySetDAO = DAOFactory.getDAOFactory().getPolicySetDAO();
        this.policyDAO = DAOFactory.getDAOFactory().getPolicyDAO();
    }

    public static List<PapContainer> getContainers(List<Pap> papList) {
        ArrayList<PapContainer> papContainerList = new ArrayList<PapContainer>(papList.size());
        for (Pap pap : papList) {
            papContainerList.add(new PapContainer(pap));
        }
        return papContainerList;
    }

    public void addPolicy(int index, String policySetId, PolicyType policy) {
        if (!this.policySetDAO.exists(this.papId, policySetId)) {
            throw new NotFoundException("PolicySetId \"" + policySetId + "\" not found");
        }
        String policyId = policy.getPolicyId();
        this.policyDAO.store(this.papId, policy);
        int numberOfRules = policy.getRules().size();
        TypeStringUtils.releaseUnneededMemory(policy);
        PolicySetType policySet = this.policySetDAO.getById(this.papId, policySetId);
        if (PolicySetHelper.referenceIdExists(policySet, policyId)) {
            throw new AlreadyExistsException("Reference id \"" + policyId + "\" alredy exists");
        }
        if (index < 0) {
            PolicySetHelper.addPolicyReference(policySet, policyId);
        } else {
            PolicySetHelper.addPolicyReference(policySet, index, policyId);
        }
        String oldVersion = policySet.getVersion();
        PolicySetWizard.increaseVersion(policySet);
        try {
            this.policySetDAO.update(this.papId, oldVersion, policySet);
        }
        catch (RepositoryException e) {
            this.policyDAO.delete(this.papId, policyId);
            throw e;
        }
        TypeStringUtils.releaseUnneededMemory(policySet);
        this.updatePapPolicyLastModificationTime();
        this.notifyPoliciesAdded(numberOfRules);
    }

    public void addPolicySet(int index, PolicySetType policySet) {
        String policySetId = policySet.getPolicySetId();
        this.policySetDAO.store(this.papId, policySet);
        PolicySetType rootPolicySet = this.policySetDAO.getById(this.papId, this.rootPolicySetId);
        if (PolicySetHelper.referenceIdExists(rootPolicySet, policySetId)) {
            throw new AlreadyExistsException("Reference id \"" + policySetId + "\" alredy exists");
        }
        if (index < 0) {
            PolicySetHelper.addPolicySetReference(rootPolicySet, policySetId);
        } else {
            PolicySetHelper.addPolicySetReference(rootPolicySet, index, policySetId);
        }
        String oldVersion = rootPolicySet.getVersion();
        PolicySetWizard.increaseVersion(rootPolicySet);
        try {
            this.policySetDAO.update(this.papId, oldVersion, rootPolicySet);
        }
        catch (RepositoryException e) {
            this.policySetDAO.delete(this.papId, policySetId);
            throw e;
        }
        TypeStringUtils.releaseUnneededMemory(rootPolicySet);
        this.updatePapPolicyLastModificationTime();
    }

    public void createRootPolicySet() {
        PolicySetType rootPolicySet = PolicySetHelper.buildWithAnyTarget(this.pap.getId(), "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable");
        rootPolicySet.setVersion("0");
        this.policySetDAO.store(this.papId, rootPolicySet);
    }

    public void deleteAllPolicies() {
        List<PolicyType> policyList = this.policyDAO.getAll(this.papId);
        int numberOfRules = 0;
        for (PolicyType policy : policyList) {
            numberOfRules += policy.getRules().size();
            TypeStringUtils.releaseUnneededMemory(policy);
        }
        this.policyDAO.deleteAll(this.papId);
        this.updatePapPolicyLastModificationTime();
        this.notifyPoliciesDeleted(numberOfRules);
    }

    public void deleteAllPolicySets() {
        this.policySetDAO.deleteAll(this.papId);
    }

    public void deletePolicy(String id) throws NotFoundException, RepositoryException {
        PolicyType policy = this.policyDAO.getById(this.papId, id);
        int numberOfRules = policy.getRules().size();
        this.policyDAO.delete(this.papId, id);
        this.updatePapPolicyLastModificationTime();
        this.notifyPoliciesDeleted(numberOfRules);
    }

    public void deletePolicySet(String id) throws NotFoundException, RepositoryException {
        this.policySetDAO.delete(this.papId, id);
    }

    public List<PolicyType> getAllPolicies() {
        return this.policyDAO.getAll(this.papId);
    }

    public List<PolicySetType> getAllPolicySets() {
        List<PolicySetType> policySetList = this.policySetDAO.getAll(this.papId);
        for (PolicySetType policySet : policySetList) {
            if (!policySet.getPolicySetId().equals(this.rootPolicySetId)) continue;
            int rootPolicySetIndex = policySetList.indexOf(policySet);
            if (rootPolicySetIndex == 0) break;
            Collections.swap(policySetList, 0, rootPolicySetIndex);
            break;
        }
        return policySetList;
    }

    public int getNumberOfPolicies() {
        List<PolicyType> policyList = this.policyDAO.getAll(this.papId);
        int numberOfRules = 0;
        for (PolicyType policy : policyList) {
            numberOfRules += policy.getRules().size();
            TypeStringUtils.releaseUnneededMemory(policy);
        }
        return numberOfRules;
    }

    public Pap getPap() {
        return this.pap;
    }

    public PolicySetType getRootPolicySet() {
        return this.policySetDAO.getById(this.papId, this.rootPolicySetId);
    }

    public String getRootPolicySetId() {
        return this.rootPolicySetId;
    }

    public PolicyType getPolicy(String id) {
        return this.policyDAO.getById(this.papId, id);
    }

    public PolicySetType getPolicySet(String id) {
        return this.policySetDAO.getById(this.papId, id);
    }

    public boolean hasPolicy(String id) {
        return this.policyDAO.exists(this.papId, id);
    }

    public boolean hasPolicySet(String id) {
        return this.policySetDAO.exists(this.papId, id);
    }

    public void purgePoliciesWithNoRules() {
        List<PolicyType> policyList = this.policyDAO.getAll(this.papId);
        for (PolicyType policy : policyList) {
            if (policy.getRules().size() != 0) continue;
            this.removePolicyAndReferences(policy.getPolicyId());
        }
    }

    public void purgePolicySetWithNoPolicies() {
        List<PolicySetType> policySetList = this.policySetDAO.getAll(this.papId);
        for (PolicySetType policySet : policySetList) {
            String policySetId = policySet.getPolicySetId();
            if (this.rootPolicySetId.equals(policySetId) || policySet.getPolicyIdReferences().size() != 0) continue;
            this.removePolicySetAndReferences(policySetId);
        }
    }

    public void purgeUnreferencedPolicySets() {
        HashSet<String> idSet = new HashSet<String>();
        PolicySetType rootPS = this.policySetDAO.getById(this.papId, this.rootPolicySetId);
        idSet.add(rootPS.getPolicySetId());
        for (String id : PolicySetHelper.getPolicySetIdReferencesValues(rootPS)) {
            idSet.add(id);
        }
        TypeStringUtils.releaseUnneededMemory(rootPS);
        for (PolicySetType policySet : this.policySetDAO.getAll(this.papId)) {
            String policySetId = policySet.getPolicySetId();
            if (idSet.contains(policySetId)) continue;
            log.info("Purging policy set " + policySetId);
            this.policySetDAO.delete(this.papId, policySetId);
        }
    }

    public void purgeUnreferencesPolicies() {
        HashSet<String> idSet = new HashSet<String>();
        for (PolicySetType policySet : this.policySetDAO.getAll(this.papId)) {
            List<String> idList = PolicySetHelper.getPolicyIdReferencesValues(policySet);
            TypeStringUtils.releaseUnneededMemory(policySet);
            for (String id : idList) {
                idSet.add(id);
            }
        }
        for (PolicyType policy : this.policyDAO.getAll(this.papId)) {
            String policyId = policy.getPolicyId();
            if (idSet.contains(policyId)) continue;
            log.info("Purging policy " + policyId);
            this.policyDAO.delete(this.papId, policyId);
        }
    }

    public void removePolicyAndReferences(String policyId) {
        if (!this.policyDAO.exists(this.papId, policyId)) {
            throw new NotFoundException("PolicyId \"" + policyId + "\" does not exists");
        }
        boolean policyAlreadyRemoved = false;
        List<PolicySetType> policySetList = this.policySetDAO.getAll(this.papId);
        for (PolicySetType policySet : policySetList) {
            if (!PolicySetHelper.deletePolicyReference(policySet, policyId)) continue;
            if (policySet.getPolicyIdReferences().size() == 0) {
                this.removePolicySetAndReferences(policySet.getPolicySetId());
                policyAlreadyRemoved = true;
            } else {
                String oldVersion = policySet.getVersion();
                PolicySetWizard.increaseVersion(policySet);
                this.policySetDAO.update(this.papId, oldVersion, policySet);
            }
            TypeStringUtils.releaseUnneededMemory(policySet);
        }
        if (policyAlreadyRemoved) {
            return;
        }
        PolicyType policy = this.policyDAO.getById(this.papId, policyId);
        int numberOfRules = policy.getRules().size();
        this.policyDAO.delete(this.papId, policyId);
        this.updatePapPolicyLastModificationTime();
        this.notifyPoliciesDeleted(numberOfRules);
    }

    public void removePolicySetAndReferences(String policySetId) {
        if (!this.policySetDAO.exists(this.papId, policySetId)) {
            throw new NotFoundException("PolicySetId \"" + policySetId + "\" does not exists");
        }
        PolicySetType rootPolicySet = this.policySetDAO.getById(this.papId, this.rootPolicySetId);
        if (PolicySetHelper.deletePolicySetReference(rootPolicySet, policySetId)) {
            String oldVersion = rootPolicySet.getVersion();
            PolicySetWizard.increaseVersion(rootPolicySet);
            this.policySetDAO.update(this.papId, oldVersion, rootPolicySet);
            TypeStringUtils.releaseUnneededMemory(rootPolicySet);
        }
        PolicySetType policySet = this.policySetDAO.getById(this.papId, policySetId);
        this.policySetDAO.delete(this.papId, policySetId);
        List<String> idList = PolicySetHelper.getPolicyIdReferencesValues(policySet);
        TypeStringUtils.releaseUnneededMemory(policySet);
        for (String policyId : idList) {
            PolicyType policy = this.policyDAO.getById(this.papId, policyId);
            int numberOfRules = policy.getRules().size();
            TypeStringUtils.releaseUnneededMemory(policy);
            this.policyDAO.delete(this.papId, policyId);
            this.notifyPoliciesDeleted(numberOfRules);
        }
        this.updatePapPolicyLastModificationTime();
    }

    public void storePolicy(PolicyType policy) {
        this.policyDAO.store(this.papId, policy);
        int numberOfRules = policy.getRules().size();
        TypeStringUtils.releaseUnneededMemory(policy);
        this.updatePapPolicyLastModificationTime();
        this.notifyPoliciesAdded(numberOfRules);
    }

    public void storePolicySet(PolicySetType policySet) {
        this.policySetDAO.store(this.papId, policySet);
    }

    public void updatePolicy(String version, PolicyType policy) {
        PolicyType oldPolicy = this.policyDAO.getById(this.papId, policy.getPolicyId());
        int numberOfRemovedRules = oldPolicy.getRules().size();
        TypeStringUtils.releaseUnneededMemory(oldPolicy);
        int numberOfAddedRules = policy.getRules().size();
        this.policyDAO.update(this.papId, version, policy);
        this.updatePapPolicyLastModificationTime();
        this.notifyPoliciesDeleted(numberOfRemovedRules);
        this.notifyPoliciesAdded(numberOfAddedRules);
    }

    public void updatePolicySet(String version, PolicySetType newPolicySet) {
        this.policySetDAO.update(this.papId, version, newPolicySet);
        this.updatePapPolicyLastModificationTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPoliciesAdded(int numOfAddedPolicies) {
        String propName = this.pap.isLocal() ? "NumberOfLocalPolicies" : "NumberOfRemotePolicies";
        Object object = notificationLock;
        synchronized (object) {
            Integer numOfPoliciesInteger = (Integer)PAPConfiguration.instance().getMonitoringProperty(propName);
            if (numOfPoliciesInteger == null) {
                return;
            }
            int numOfPolicies = numOfPoliciesInteger + numOfAddedPolicies;
            numOfPoliciesInteger = new Integer(numOfPolicies);
            PAPConfiguration.instance().setMonitoringProperty(propName, numOfPoliciesInteger);
            propName = "NumberOfPolicies";
            numOfPoliciesInteger = (Integer)PAPConfiguration.instance().getMonitoringProperty(propName);
            numOfPolicies = numOfPoliciesInteger + numOfAddedPolicies;
            numOfPoliciesInteger = new Integer(numOfPolicies);
            PAPConfiguration.instance().setMonitoringProperty(propName, numOfPoliciesInteger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPoliciesDeleted(int numOfDeletedPolicies) {
        String propName = this.pap.isLocal() ? "NumberOfLocalPolicies" : "NumberOfRemotePolicies";
        Object object = notificationLock;
        synchronized (object) {
            Integer numOfPoliciesInteger = (Integer)PAPConfiguration.instance().getMonitoringProperty(propName);
            if (numOfPoliciesInteger == null) {
                return;
            }
            int numOfPolicies = numOfPoliciesInteger - numOfDeletedPolicies;
            numOfPoliciesInteger = new Integer(numOfPolicies);
            PAPConfiguration.instance().setMonitoringProperty(propName, numOfPoliciesInteger);
            propName = "NumberOfPolicies";
            numOfPoliciesInteger = (Integer)PAPConfiguration.instance().getMonitoringProperty(propName);
            numOfPolicies = numOfPoliciesInteger - numOfDeletedPolicies;
            numOfPoliciesInteger = new Integer(numOfPolicies);
            PAPConfiguration.instance().setMonitoringProperty(propName, numOfPoliciesInteger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPolicyLastModificationTimeUpdate() {
        if (this.pap.isRemote()) {
            return;
        }
        Object object = notificationLock;
        synchronized (object) {
            String lastModificationTimeString = this.pap.getPolicyLastModificationTimeInMilliseconds();
            PAPConfiguration.instance().setMonitoringProperty("PolicyLastModificationTimeMillis", lastModificationTimeString);
            DateTime lastModificationTime = new DateTime(Long.parseLong(lastModificationTimeString)).withChronology((Chronology)ISOChronology.getInstanceUTC());
            PAPConfiguration.instance().setMonitoringProperty("PolicyLastModificationTime", lastModificationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePapPolicyLastModificationTime() {
        this.pap.setPolicyLastModificationTime(new GregorianCalendar().getTimeInMillis());
        Object object = notificationLock;
        synchronized (object) {
            DAOFactory.getDAOFactory().getPapDAO().update(this.pap);
        }
        this.notifyPolicyLastModificationTimeUpdate();
    }
}

