/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.encoder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.glite.authz.pap.common.xacml.wizard.XACMLWizard;
import org.glite.authz.pap.encoder.EncodingException;
import org.glite.authz.pap.encoder.parser.BWParser;
import org.glite.authz.pap.encoder.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyFileEncoder {
    BWParser parser = null;

    private void init(InputStream stream) {
        if (this.parser != null) {
            BWParser.ReInit(stream);
        } else {
            this.parser = new BWParser(stream);
        }
    }

    private List<XACMLWizard> doParse() throws EncodingException {
        try {
            PolicyFileEncoder policyFileEncoder = this;
            return policyFileEncoder.parser.Text();
        }
        catch (ParseException e) {
            throw new EncodingException(e);
        }
    }

    public List<XACMLWizard> parse(InputStream stream) throws EncodingException {
        this.init(stream);
        return this.doParse();
    }

    public List<XACMLWizard> parse(String text) throws EncodingException {
        this.init(new ByteArrayInputStream(text.getBytes()));
        return this.doParse();
    }

    public List<XACMLWizard> parse(File file) throws EncodingException {
        try {
            this.init(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new EncodingException(e);
        }
        return this.doParse();
    }
}

