/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.distribution;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.distribution.DistributionConfiguration;
import org.glite.authz.pap.distribution.PAPClient;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.opensaml.xacml.XACMLObject;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionModule
extends Thread {
    public static final Object storePoliciesLock = new Object();
    private static final Logger log = LoggerFactory.getLogger(DistributionModule.class);
    private static DistributionModule instance = null;
    private long sleepTime;
    private boolean stayRunning = true;

    private DistributionModule() {
        this.initialize();
    }

    public static DistributionModule getInstance() {
        if (instance == null) {
            instance = new DistributionModule();
        }
        return instance;
    }

    public static void refreshCache(Pap pap) throws RemoteException, ServiceException {
        log.info("Refreshing cache of remote PAP " + pap.getAlias());
        List<XACMLObject> papPolicies = DistributionModule.getPoliciesFromPap(pap);
        log.info(String.format("Retrieved %d XACML objects from PAP %s (%s)", papPolicies.size(), pap.getAlias(), pap.getEndpoint()));
        DistributionModule.storePapPolicies(pap, papPolicies);
    }

    private static List<XACMLObject> getPoliciesFromPap(Pap remotePap) throws RemoteException, ServiceException {
        if (!remotePap.isRemote()) {
            log.error("Attempting to fetch policies from the local pap: " + remotePap.getAlias());
            return new ArrayList<XACMLObject>(0);
        }
        PAPClient client = new PAPClient(remotePap.getEndpoint());
        List<XACMLObject> papPolicies = client.retrievePolicies();
        return papPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storePapPolicies(Pap pap, List<XACMLObject> papPolicies) {
        if (papPolicies.isEmpty()) {
            return;
        }
        log.debug(String.format("Storing policies for PAP %s (id=%s)", pap.getAlias(), pap.getId()));
        PapManager papManager = PapManager.getInstance();
        PapContainer papContainer = papManager.getPapContainer(pap.getAlias());
        Object object = storePoliciesLock;
        synchronized (object) {
            papContainer.deleteAllPolicies();
            papContainer.deleteAllPolicySets();
            XACMLObject papRoot = papPolicies.get(0);
            if (papRoot instanceof PolicySetType) {
                ((PolicySetType)papRoot).setPolicySetId(papContainer.getPap().getId());
                for (XACMLObject xacmlObject : papPolicies) {
                    if (xacmlObject instanceof PolicySetType) {
                        PolicySetType policySet = (PolicySetType)xacmlObject;
                        papContainer.storePolicySet(policySet);
                        log.debug(String.format("Stored PolicySet \"%s\" into pap \"%s\"", policySet.getPolicySetId(), pap.getAlias()));
                    } else if (xacmlObject instanceof PolicyType) {
                        PolicyType policy = (PolicyType)xacmlObject;
                        papContainer.storePolicy(policy);
                        log.debug(String.format("Stored Policy \"%s\" into pap \"%s\"", policy.getPolicyId(), pap.getAlias()));
                    } else {
                        log.error(String.format("Invalid object (not a Policy or PolicySet) received from PAP %s (%s)", pap.getAlias(), pap.getEndpoint()));
                    }
                    TypeStringUtils.releaseUnneededMemory(xacmlObject);
                }
            } else {
                log.error(String.format("The root of the policy tree is not a PolicySet (papAlias=%s, endpoint=%s)", pap.getAlias(), pap.getEndpoint()));
            }
        }
    }

    @Override
    public void run() {
        while (this.stayRunning) {
            try {
                while (!this.isInterrupted()) {
                    log.info("Starting refresh cache thread...");
                    for (Pap pap : PapManager.getInstance().getRemotePaps()) {
                        if (this.isInterrupted()) break;
                        try {
                            DistributionModule.refreshCache(pap);
                        }
                        catch (RemoteException e) {
                            log.error(String.format("Error connecting to %s (%s): %s", pap.getAlias(), pap.getEndpoint(), e.getMessage()));
                        }
                        catch (ServiceException e) {
                            log.error(String.format("Cannot connect to: %s (%s)", pap.getAlias(), pap.getEndpoint(), e.getMessage()));
                        }
                    }
                    log.info("Refresh cache thread done.");
                    DistributionModule.sleep(this.sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void startDistributionModule() {
        this.start();
    }

    public void setSleepTime(long seconds) {
        this.sleepTime = seconds * 1000L;
        this.interrupt();
    }

    public void stopDistributionModule() {
        this.stayRunning = false;
        this.interrupt();
        while (this.isAlive()) {
        }
    }

    protected void initialize() {
        log.info("Initilizing distribution module...");
        this.sleepTime = DistributionConfiguration.getInstance().getPollIntervall() * 1000L;
    }
}

