/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.distribution;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.distribution.DistributionConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DistributionConfiguration.class);
    private static final String PAPS_STANZA = "paps";
    private static final String PAPS_PROPERTIES_STANZA = "paps:properties";
    private static DistributionConfiguration instance = null;
    private PAPConfiguration papConfiguration = PAPConfiguration.instance();

    private DistributionConfiguration() {
    }

    public static DistributionConfiguration getInstance() {
        if (instance == null) {
            instance = new DistributionConfiguration();
        }
        return instance;
    }

    private static String aliasKey(String papAlias) {
        return "paps." + papAlias;
    }

    private static String dnKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "dn";
    }

    private static String enabledKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "enabled";
    }

    private static String hostnameKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "hostname";
    }

    private static String minKeyLengthKey() {
        return "paps.min_key_length";
    }

    private static String minKeyLengthKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "min_key_length";
    }

    private static String papOrderingKey() {
        return "paps:properties.ordering";
    }

    private static String pathKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "path";
    }

    private static String pollIntervallKey() {
        return "paps:properties.poll_interval";
    }

    private static String portKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "port";
    }

    private static String protocolKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "protocol";
    }

    private static String typeKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "type";
    }

    private static String visibilityPublicKey(String papAlias) {
        return DistributionConfiguration.aliasKey(papAlias) + "." + "public";
    }

    public List<Pap> getPapList() {
        Set<String> aliasSet = Utils.getAliasSet(this.papConfiguration.getKeys(PAPS_STANZA));
        ArrayList<Pap> papList = new ArrayList<Pap>(aliasSet.size());
        for (String papAlias : aliasSet) {
            if ("default".equals(papAlias)) continue;
            papList.add(this.getPapFromProperties(papAlias));
        }
        return papList;
    }

    public String[] getPapOrdering() {
        String[] papOrderingArray = this.papConfiguration.getStringArray(DistributionConfiguration.papOrderingKey());
        if (papOrderingArray == null) {
            papOrderingArray = new String[]{};
        }
        this.validatePapOrdering(papOrderingArray);
        return papOrderingArray;
    }

    public long getPollIntervall() {
        long pollIntervalInSecs = this.papConfiguration.getLong(DistributionConfiguration.pollIntervallKey());
        log.info("Polling interval for remote paps is set to: " + pollIntervalInSecs + " seconds");
        return pollIntervalInSecs;
    }

    public void savePollInterval(long seconds) {
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.pollIntervallKey());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.pollIntervallKey(), seconds);
        this.papConfiguration.saveStartupConfiguration();
    }

    public void removePap(String papAlias) {
        String[] oldPapOrdering = this.getPapOrdering();
        this.clearPapProperties(papAlias);
        int newArraySize = oldPapOrdering.length - 1;
        if (newArraySize >= 0) {
            String[] newPapOrdering = new String[newArraySize];
            int j = 0;
            for (int i = 0; i < oldPapOrdering.length; ++i) {
                String aliasItem = oldPapOrdering[i];
                if (aliasItem.equals(papAlias) || j >= newArraySize) continue;
                newPapOrdering[j] = aliasItem;
                ++j;
            }
            this.savePapOrdering(newPapOrdering);
        }
        this.papConfiguration.saveStartupConfiguration();
    }

    public void savePap(Pap pap) {
        this.setPapProperties(pap);
        this.papConfiguration.saveStartupConfiguration();
    }

    public void savePapOrdering(String[] aliasArray) {
        if (aliasArray == null) {
            this.papConfiguration.clearDistributionProperty(DistributionConfiguration.papOrderingKey());
            this.papConfiguration.saveStartupConfiguration();
            return;
        }
        this.validatePapOrdering(aliasArray);
        if (aliasArray.length == 0) {
            this.papConfiguration.clearDistributionProperty(DistributionConfiguration.papOrderingKey());
            this.papConfiguration.saveStartupConfiguration();
            return;
        }
        StringBuilder sb = new StringBuilder(aliasArray[0]);
        for (int i = 1; i < aliasArray.length; ++i) {
            sb.append(", " + aliasArray[i]);
        }
        log.info("Setting new paps ordering to: " + sb.toString());
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.papOrderingKey());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.papOrderingKey(), aliasArray);
        this.papConfiguration.saveStartupConfiguration();
    }

    private boolean aliasExists(String alias) {
        if (!Utils.isDefined(alias)) {
            return false;
        }
        if ("default".equals(alias)) {
            return true;
        }
        String value = this.papConfiguration.getString(DistributionConfiguration.typeKey(alias));
        return Utils.isDefined(value);
    }

    private void clearPapProperties(String papAlias) {
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.dnKey(papAlias));
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.hostnameKey(papAlias));
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.enabledKey(papAlias));
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.portKey(papAlias));
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.pathKey(papAlias));
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.protocolKey(papAlias));
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.visibilityPublicKey(papAlias));
        this.papConfiguration.clearDistributionProperty(DistributionConfiguration.typeKey(papAlias));
    }

    private Pap getPapFromProperties(String papAlias) {
        String type = this.papConfiguration.getString(DistributionConfiguration.typeKey(papAlias));
        if (type == null) {
            throw new DistributionConfigurationException("\"type\" is not set for remote pap \"" + papAlias + "\"");
        }
        boolean isLocal = Pap.isLocal(type);
        String dn = this.papConfiguration.getString(DistributionConfiguration.dnKey(papAlias));
        String hostname = this.papConfiguration.getString(DistributionConfiguration.hostnameKey(papAlias));
        if (hostname == null && !isLocal) {
            throw new DistributionConfigurationException("\"hostname\" is not set for remote pap \"" + papAlias + "\"");
        }
        String port = this.papConfiguration.getString(DistributionConfiguration.portKey(papAlias));
        String path = this.papConfiguration.getString(DistributionConfiguration.pathKey(papAlias));
        String protocol = this.papConfiguration.getString(DistributionConfiguration.protocolKey(papAlias));
        boolean visibilityPublic = this.papConfiguration.getBoolean(DistributionConfiguration.visibilityPublicKey(papAlias));
        boolean enabled = this.papConfiguration.getBoolean(DistributionConfiguration.enabledKey(papAlias), false);
        Pap pap = new Pap(papAlias, isLocal, dn, hostname, port, path, protocol, visibilityPublic);
        pap.setEnabled(enabled);
        return pap;
    }

    private void setPapProperties(Pap pap) {
        String papAlias = pap.getAlias();
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.typeKey(papAlias), pap.getTypeAsString());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.enabledKey(papAlias), pap.isEnabled());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.dnKey(papAlias), pap.getDn());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.hostnameKey(papAlias), pap.getHostname());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.portKey(papAlias), pap.getPort());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.pathKey(papAlias), pap.getPath());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.protocolKey(papAlias), pap.getProtocol());
        this.papConfiguration.setDistributionProperty(DistributionConfiguration.visibilityPublicKey(papAlias), pap.isVisibilityPublic());
    }

    private void validatePapOrdering(String[] aliasArray) {
        if (aliasArray == null) {
            throw new DistributionConfigurationException("aliasArray is null");
        }
        HashSet<String> aliasSet = new HashSet<String>(aliasArray.length);
        for (String alias : aliasArray) {
            if (aliasSet.contains(alias)) {
                throw new DistributionConfigurationException(String.format("Error in remote paps order: alias \"%s\" appears more than one time", alias));
            }
            aliasSet.add(alias);
            if (this.aliasExists(alias)) continue;
            throw new DistributionConfigurationException(String.format("Error in remote paps order: unknown alias \"%s\"", alias));
        }
    }
}

