/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardType;
import org.opensaml.xacml.ctx.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardUtils {
    public static String generateId(String prefix) {
        String id = WizardUtils.generateUUID();
        if (prefix == null) {
            return id;
        }
        if (prefix.length() == 0) {
            return id;
        }
        return prefix + "-" + WizardUtils.generateUUID();
    }

    public static List<AttributeType> getAttributes(List<AttributeWizard> list, AttributeWizardType.TargetElement type) {
        LinkedList<AttributeType> resultList = new LinkedList<AttributeType>();
        for (AttributeWizard attribute : list) {
            if (!type.equals((Object)attribute.getTargetElementType())) continue;
            resultList.add(attribute.getXACML());
        }
        return resultList;
    }

    private static String generateUUID() {
        return UUID.randomUUID().toString();
    }
}

