/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.common.xacml.utils.ActionHelper;
import org.glite.authz.pap.common.xacml.utils.ActionMatchHelper;
import org.glite.authz.pap.common.xacml.utils.ActionsHelper;
import org.glite.authz.pap.common.xacml.utils.EnvironmentHelper;
import org.glite.authz.pap.common.xacml.utils.EnvironmentMatchHelper;
import org.glite.authz.pap.common.xacml.utils.EnvironmentsHelper;
import org.glite.authz.pap.common.xacml.utils.ResourceHelper;
import org.glite.authz.pap.common.xacml.utils.ResourceMatchHelper;
import org.glite.authz.pap.common.xacml.utils.ResourcesHelper;
import org.glite.authz.pap.common.xacml.utils.SubjectHelper;
import org.glite.authz.pap.common.xacml.utils.SubjectMatchHelper;
import org.glite.authz.pap.common.xacml.utils.SubjectsHelper;
import org.glite.authz.pap.common.xacml.utils.TargetHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.exceptions.TargetWizardException;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedTargetException;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.policy.ActionMatchType;
import org.opensaml.xacml.policy.ActionType;
import org.opensaml.xacml.policy.ActionsType;
import org.opensaml.xacml.policy.EnvironmentMatchType;
import org.opensaml.xacml.policy.EnvironmentType;
import org.opensaml.xacml.policy.EnvironmentsType;
import org.opensaml.xacml.policy.ResourceMatchType;
import org.opensaml.xacml.policy.ResourceType;
import org.opensaml.xacml.policy.ResourcesType;
import org.opensaml.xacml.policy.SubjectMatchType;
import org.opensaml.xacml.policy.SubjectType;
import org.opensaml.xacml.policy.SubjectsType;
import org.opensaml.xacml.policy.TargetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetWizard {
    private static final Logger log = LoggerFactory.getLogger(TargetWizard.class);
    private TargetType target = null;
    private final List<AttributeWizard> targetAttributeWizardList;

    public TargetWizard(AttributeWizard attributeWizard) {
        this.targetAttributeWizardList = Arrays.asList(attributeWizard);
    }

    public TargetWizard(List<AttributeWizard> targetAttributeWizardList) {
        this.targetAttributeWizardList = targetAttributeWizardList == null ? Collections.emptyList() : targetAttributeWizardList;
    }

    public TargetWizard(TargetType target) {
        this.target = target;
        this.targetAttributeWizardList = TargetWizard.buildAttributeWizardList(target);
    }

    private static List<AttributeWizard> buildAttributeWizardList(TargetType target) {
        List environmentList;
        EnvironmentsType environments;
        List actionList;
        ActionsType actions;
        List resourceList;
        ResourcesType resources;
        List subjectList;
        LinkedList<AttributeWizard> attributeWizardList = new LinkedList<AttributeWizard>();
        LinkedList<AttributeType> attributeList = new LinkedList<AttributeType>();
        SubjectsType subjects = target.getSubjects();
        if (subjects != null && !(subjectList = subjects.getSubjects()).isEmpty()) {
            if (subjectList.size() > 1) {
                throw new UnsupportedTargetException("Only one SubjectType is allowed");
            }
            attributeList.addAll(SubjectMatchHelper.getAttributeList(((SubjectType)subjectList.get(0)).getSubjectMatches()));
        }
        if ((resources = target.getResources()) != null && !(resourceList = resources.getResources()).isEmpty()) {
            if (resourceList.size() > 1) {
                throw new UnsupportedTargetException("Only one ResourceType is allowed");
            }
            attributeList.addAll(ResourceMatchHelper.getAttributeList(((ResourceType)resourceList.get(0)).getResourceMatches()));
        }
        if ((actions = target.getActions()) != null && !(actionList = actions.getActions()).isEmpty()) {
            if (actionList.size() > 1) {
                throw new UnsupportedTargetException("Only one ActionType is allowed");
            }
            attributeList.addAll(ActionMatchHelper.getAttributeList(((ActionType)actionList.get(0)).getActionMatches()));
        }
        if ((environments = target.getEnvironments()) != null && !(environmentList = environments.getEnvrionments()).isEmpty()) {
            if (environmentList.size() > 1) {
                throw new UnsupportedTargetException("Only one EnvironmentType is allowed");
            }
            attributeList.addAll(EnvironmentMatchHelper.getAttributeList(((EnvironmentType)environmentList.get(0)).getEnvrionmentMatches()));
        }
        for (AttributeType attribute : attributeList) {
            attributeWizardList.add(new AttributeWizard(attribute));
        }
        return attributeWizardList;
    }

    public List<AttributeWizard> getAttributeWizardList() {
        return this.targetAttributeWizardList;
    }

    public TargetType getXACML() {
        this.initTargetTypeIfNotSet();
        return this.target;
    }

    public boolean isEquivalent(TargetType target) {
        TargetWizard targetWizard;
        if (target == null) {
            return false;
        }
        try {
            targetWizard = new TargetWizard(target);
        }
        catch (TargetWizardException e) {
            return false;
        }
        return this.isEquivalent(targetWizard);
    }

    public boolean isEquivalent(TargetWizard targetWizard) {
        List<AttributeWizard> attributeWizardList = targetWizard.getAttributeWizardList();
        if (this.targetAttributeWizardList.size() != attributeWizardList.size()) {
            return false;
        }
        for (AttributeWizard thisAttributeWizard : this.targetAttributeWizardList) {
            boolean found = false;
            for (AttributeWizard attributeWizard : attributeWizardList) {
                if (!thisAttributeWizard.equals(attributeWizard)) continue;
                found = true;
                break;
            }
            if (found) continue;
            log.debug(thisAttributeWizard.toFormattedString() + " NOT FOUND");
            return false;
        }
        return true;
    }

    public void releaseChildrenDOM() {
        if (this.target != null) {
            this.target.releaseChildrenDOM(true);
        }
    }

    public void releaseDOM() {
        if (this.target != null) {
            this.target.releaseDOM();
            this.target = null;
        }
    }

    private void initTargetTypeIfNotSet() {
        if (this.target == null) {
            this.setTargetType();
        }
    }

    private void setTargetType() {
        this.releaseDOM();
        LinkedList<SubjectMatchType> subjectMatchTypeList = new LinkedList<SubjectMatchType>();
        for (AttributeWizard attributeWizard : this.targetAttributeWizardList) {
            if (!attributeWizard.isSubjectAttribute()) continue;
            subjectMatchTypeList.add(SubjectMatchHelper.buildWithDesignator(attributeWizard.getXACML(), attributeWizard.getMatchfunction(), attributeWizard.getMatchFunctionDataType()));
        }
        LinkedList<ResourceMatchType> resourceMatchTypeList = new LinkedList<ResourceMatchType>();
        for (AttributeWizard attributeWizard : this.targetAttributeWizardList) {
            if (!attributeWizard.isResourceAttribute()) continue;
            resourceMatchTypeList.add(ResourceMatchHelper.buildWithDesignator(attributeWizard.getXACML(), attributeWizard.getMatchfunction(), attributeWizard.getMatchFunctionDataType()));
        }
        LinkedList<ActionMatchType> actionMatchTypeList = new LinkedList<ActionMatchType>();
        for (AttributeWizard attributeWizard : this.targetAttributeWizardList) {
            if (!attributeWizard.isActionAttribute()) continue;
            actionMatchTypeList.add(ActionMatchHelper.buildWithDesignator(attributeWizard.getXACML(), attributeWizard.getMatchfunction(), attributeWizard.getMatchFunctionDataType()));
        }
        LinkedList<EnvironmentMatchType> environmentMatchTypeList = new LinkedList<EnvironmentMatchType>();
        for (AttributeWizard attributeWizard : this.targetAttributeWizardList) {
            if (!attributeWizard.isEnvironmentAttribute()) continue;
            environmentMatchTypeList.add(EnvironmentMatchHelper.buildWithDesignator(attributeWizard.getXACML(), attributeWizard.getMatchfunction(), attributeWizard.getMatchFunctionDataType()));
        }
        SubjectsType subjects = SubjectsHelper.build(SubjectHelper.build(subjectMatchTypeList));
        ResourcesType resources = ResourcesHelper.build(ResourceHelper.build(resourceMatchTypeList));
        ActionsType actions = ActionsHelper.build(ActionHelper.build(actionMatchTypeList));
        EnvironmentsType environments = EnvironmentsHelper.build(EnvironmentHelper.build(environmentMatchTypeList));
        this.target = TargetHelper.build(subjects, actions, resources, environments);
    }
}

