/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.common.xacml.impl.PolicyTypeString;
import org.glite.authz.pap.common.xacml.utils.DescriptionTypeHelper;
import org.glite.authz.pap.common.xacml.utils.ObligationsHelper;
import org.glite.authz.pap.common.xacml.utils.PolicyHelper;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardType;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardTypeConfiguration;
import org.glite.authz.pap.common.xacml.wizard.ObligationWizard;
import org.glite.authz.pap.common.xacml.wizard.RuleWizard;
import org.glite.authz.pap.common.xacml.wizard.TargetWizard;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.common.xacml.wizard.XACMLWizard;
import org.glite.authz.pap.common.xacml.wizard.exceptions.PolicyWizardException;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedPolicyException;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedPolicySetWizardException;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.RuleType;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyWizard
extends XACMLWizard {
    private static final Logger log = LoggerFactory.getLogger(PolicyWizard.class);
    protected static final String VISIBILITY_PRIVATE_PREFIX = "private";
    protected static final String VISIBILITY_PUBLIC_PREFIX = "public";
    protected final String actionValue;
    protected static final AttributeWizardType attributeWizardType = AttributeWizardTypeConfiguration.getInstance().getActionAttributeWizard();
    protected final List<ObligationWizard> obligationWizardList = new LinkedList<ObligationWizard>();
    protected final List<RuleWizard> ruleWizardList = new LinkedList<RuleWizard>();
    protected final TargetWizard targetWizard;
    protected String description = null;
    protected boolean isPrivate = false;
    protected PolicyTypeString policy = null;
    protected String policyId = null;
    protected String policyIdUniqueNumber;
    protected String version = null;

    public PolicyWizard(AttributeWizard attributeWizard) {
        if (attributeWizardType != attributeWizard.getAttributeWizardType()) {
            throw new UnsupportedPolicyException("Attribute not supported: " + attributeWizard.getId());
        }
        this.actionValue = attributeWizard.getValue();
        this.targetWizard = new TargetWizard(attributeWizard);
        this.policyId = this.generatePolicyId();
        this.version = "1";
    }

    public PolicyWizard(PolicyType policy) {
        if (!(policy instanceof PolicyTypeString)) {
            throw new PolicyWizardException("Argument is not PolicyTypeString");
        }
        this.targetWizard = new TargetWizard(policy.getTarget());
        List<AttributeWizard> targetAttributeWizardList = this.targetWizard.getAttributeWizardList();
        PolicyWizard.validateTargetAttributewizardList(targetAttributeWizardList);
        this.policyId = policy.getPolicyId();
        this.decomposePolicyId(policy.getPolicyId());
        this.actionValue = targetAttributeWizardList.get(0).getValue();
        if (policy.getDescription() != null) {
            this.description = policy.getDescription().getValue();
        }
        try {
            this.version = policy.getVersion();
            new Integer(this.version);
        }
        catch (NumberFormatException e) {
            throw new UnsupportedPolicyException("Wrong version format", e);
        }
        if (policy.getObligations() != null) {
            List obligationList = policy.getObligations().getObligations();
            for (ObligationType obligation : obligationList) {
                this.obligationWizardList.add(new ObligationWizard(obligation));
            }
        }
        for (RuleType rule : policy.getRules()) {
            this.ruleWizardList.add(new RuleWizard(rule));
        }
        this.policy = (PolicyTypeString)policy;
    }

    public static String getActionValue(PolicyType policy) {
        TargetWizard targetWizard = new TargetWizard(policy.getTarget());
        List<AttributeWizard> targetAttributeWizardList = targetWizard.getAttributeWizardList();
        PolicyWizard.validateTargetAttributewizardList(targetAttributeWizardList);
        return targetAttributeWizardList.get(0).getValue();
    }

    public static void increaseVersion(PolicyType policy) {
        int version;
        try {
            version = new Integer(policy.getVersion());
            ++version;
        }
        catch (NumberFormatException e) {
            log.error("Unrecognized version format, setting version to 1. PolicySetId=" + policy.getPolicyId());
            version = 1;
        }
        policy.setVersion(Integer.toString(version));
    }

    public static boolean isPrivate(String policyId) {
        return !PolicyWizard.isPublic(policyId);
    }

    public static boolean isPublic(String policyId) {
        String[] idTokens = policyId.split("_");
        if (idTokens.length == 0) {
            throw new UnsupportedPolicyException("Unrecognized policyId: " + policyId);
        }
        if (idTokens.length == 1) {
            return true;
        }
        return !VISIBILITY_PRIVATE_PREFIX.equals(idTokens[0]);
    }

    private static String getIdUniqueNumber(String policyId) {
        String[] idTokens = policyId.split("_");
        if (idTokens.length == 0) {
            throw new UnsupportedPolicyException("Unrecognized policyId: " + policyId);
        }
        if (idTokens.length == 1) {
            return idTokens[0];
        }
        if (idTokens.length == 2 && (VISIBILITY_PRIVATE_PREFIX.equals(idTokens[0]) || VISIBILITY_PUBLIC_PREFIX.equals(idTokens[0]))) {
            return idTokens[1];
        }
        throw new UnsupportedPolicyException("Unrecognized policyId: " + policyId);
    }

    public void addObligation(ObligationWizard obligationWizard) {
        this.obligationWizardList.add(obligationWizard);
        this.invalidatePolicyType();
    }

    public void addRule(AttributeWizard attribute, EffectType effect) {
        this.addRule(new RuleWizard(attribute, effect));
    }

    public void addRule(int index, AttributeWizard attribute, EffectType effect) {
        this.addRule(index, new RuleWizard(attribute, effect));
    }

    public void addRule(int index, List<AttributeWizard> targetAttributeList, EffectType effect) {
        this.addRule(new RuleWizard(targetAttributeList, effect));
    }

    public void addRule(int index, RuleWizard ruleWizard) {
        this.ruleWizardList.add(index, ruleWizard);
        this.invalidatePolicyType();
    }

    public void addRule(List<AttributeWizard> targetAttributeList, EffectType effect) {
        this.addRule(new RuleWizard(targetAttributeList, effect));
    }

    public void addRule(RuleWizard ruleWizard) {
        this.ruleWizardList.add(ruleWizard);
        this.invalidatePolicyType();
    }

    public boolean denyRuleForAttributeExists(AttributeWizard attributeWizard) {
        for (RuleWizard ruleWizard : this.ruleWizardList) {
            if (!ruleWizard.deniesAttribute(attributeWizard)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumberOfRules() {
        return this.ruleWizardList.size();
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPolicyIdPrefix() {
        if (this.isPrivate) {
            return VISIBILITY_PRIVATE_PREFIX;
        }
        return VISIBILITY_PUBLIC_PREFIX;
    }

    public String getTagAndValue() {
        return String.format("%s \"%s\"", attributeWizardType.getId(), this.actionValue);
    }

    public int getVersion() {
        return Integer.valueOf(this.version);
    }

    public String getVersionString() {
        return this.version;
    }

    public PolicyType getXACML() {
        this.initPolicyTypeIfNotSet();
        return this.policy;
    }

    public void increaseVersion() {
        this.setVersion(this.getVersion() + 1);
    }

    public boolean isDOMReleased() {
        return this.policy == null;
    }

    public boolean isEquivalent(PolicyType policy) {
        if (!this.targetWizard.isEquivalent(policy.getTarget())) {
            return false;
        }
        List ruleList = policy.getRules();
        if (ruleList.size() != this.ruleWizardList.size()) {
            return false;
        }
        for (int i = 0; i < this.ruleWizardList.size(); ++i) {
            if (this.ruleWizardList.get(i).isEquivalent((RuleType)ruleList.get(i))) continue;
            return false;
        }
        return !(this.description != null ? !this.description.equals(policy.getDescription()) : policy.getDescription() != null);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isPublic() {
        return !this.isPrivate;
    }

    public void releaseChildrenDOM() {
        this.targetWizard.releaseChildrenDOM();
        this.targetWizard.releaseDOM();
        for (ObligationWizard obligationWizard : this.obligationWizardList) {
            obligationWizard.releaseChildrenDOM();
            obligationWizard.releaseDOM();
        }
        for (RuleWizard ruleWizard : this.ruleWizardList) {
            ruleWizard.releaseChildrenDOM();
            ruleWizard.releaseDOM();
        }
    }

    public void releaseDOM() {
        if (this.policy != null) {
            this.policy.releaseDOM();
            this.policy = null;
        }
    }

    public boolean removeDenyRuleForAttribute(AttributeWizard attributeWizard) {
        for (int i = 0; i < this.ruleWizardList.size(); ++i) {
            RuleWizard ruleWizard = this.ruleWizardList.get(i);
            if (!ruleWizard.deniesAttribute(attributeWizard)) continue;
            if (this.policy != null) {
                PolicyHelper.removeRule(this.policy, ruleWizard.getRuleId());
            }
            this.ruleWizardList.remove(i);
            return true;
        }
        return false;
    }

    public void setDescription(String value) {
        this.description = value;
        if (this.policy != null) {
            this.policy.setDescription(DescriptionTypeHelper.build(value));
        }
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
        if (this.policy != null) {
            this.policy.setPolicyId(policyId);
        }
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        this.policyId = this.composeId();
        if (this.policy != null) {
            this.policy.setPolicyId(this.policyId);
        }
    }

    public void setVersion(int version) {
        this.version = Integer.toString(version);
        if (this.policy != null) {
            this.policy.setVersion(this.version);
        }
    }

    public String toFormattedString() {
        return this.toFormattedString(false);
    }

    public String toFormattedString(boolean printPolicyId) {
        return this.toFormattedString(0, 4, printPolicyId, false);
    }

    public String toFormattedString(int baseIndentation, int internalIndentation) {
        return this.toFormattedString(baseIndentation, internalIndentation, false, false);
    }

    public String toFormattedString(int baseIndentation, int internalIndentation, boolean printPolicyId, boolean printRuleIds) {
        String baseIndentString = Utils.fillWithSpaces(baseIndentation);
        String indentString = Utils.fillWithSpaces(baseIndentation + internalIndentation);
        StringBuffer sb = new StringBuffer();
        if (printPolicyId) {
            sb.append(String.format("%sid=%s\n", baseIndentString, this.policyId));
        }
        if (this.isPrivate()) {
            sb.append(String.format("%sprivate\n", baseIndentString));
        }
        sb.append(String.format("%saction \"%s\" {\n", baseIndentString, this.actionValue));
        if (this.description != null) {
            sb.append(String.format("%sdescription=\"%s\"\n", indentString, this.description));
        }
        for (ObligationWizard obligationWizard : this.obligationWizardList) {
            sb.append(obligationWizard.toFormattedString(baseIndentation + internalIndentation, internalIndentation));
            sb.append('\n');
        }
        for (RuleWizard ruleWizard : this.ruleWizardList) {
            if (printRuleIds) {
                sb.append('\n');
            }
            sb.append(ruleWizard.toFormattedString(baseIndentation + internalIndentation, internalIndentation, printRuleIds));
            sb.append('\n');
        }
        sb.append(baseIndentString + "}");
        return sb.toString();
    }

    public String toXACMLString() {
        this.initPolicyTypeIfNotSet();
        return XMLObjectHelper.toString((XMLObject)this.policy);
    }

    private String composeId() {
        return this.getPolicyIdPrefix() + "_" + this.policyIdUniqueNumber;
    }

    private void decomposePolicyId(String policyId) {
        this.isPrivate = PolicyWizard.isPrivate(policyId);
        this.policyIdUniqueNumber = PolicyWizard.getIdUniqueNumber(policyId);
    }

    private String generatePolicyId() {
        this.policyIdUniqueNumber = WizardUtils.generateId(null);
        return this.composeId();
    }

    private void initPolicyTypeIfNotSet() {
        if (this.policy == null) {
            log.debug("Initializing policyType");
            this.setPolicyType();
        } else {
            log.debug("policyType already initialized");
        }
    }

    private void invalidatePolicyType() {
        this.releaseChildrenDOM();
        this.releaseDOM();
    }

    private void setPolicyType() {
        this.releaseDOM();
        this.policy = new PolicyTypeString(PolicyHelper.build(this.policyId, "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable"));
        if (this.description != null) {
            this.policy.setDescription(DescriptionTypeHelper.build(this.description));
        }
        this.policy.setTarget(this.targetWizard.getXACML());
        this.policy.setVersion(this.version);
        if (this.obligationWizardList.size() > 0) {
            ObligationsType obligations = ObligationsHelper.build();
            List obligationList = obligations.getObligations();
            for (ObligationWizard obligationWizard : this.obligationWizardList) {
                obligationList.add(obligationWizard.getXACML());
            }
            this.policy.setObligations(obligations);
        }
        for (RuleWizard ruleWizard : this.ruleWizardList) {
            this.policy.getRules().add(ruleWizard.getXACML());
        }
    }

    private static void validateTargetAttributewizardList(List<AttributeWizard> targetAttributeWizardList) {
        if (targetAttributeWizardList == null) {
            throw new UnsupportedPolicySetWizardException("targetAttributeWizardList is null");
        }
        if (targetAttributeWizardList.size() != 1) {
            throw new UnsupportedPolicySetWizardException("Only one action attribute is supported (found " + targetAttributeWizardList.size() + " attributes)");
        }
        AttributeWizard aw = targetAttributeWizardList.get(0);
        if (aw.getAttributeWizardType() != attributeWizardType) {
            throw new UnsupportedPolicySetWizardException("Only one action attribute is supported");
        }
    }
}

