/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.common.xacml.utils.ObligationHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.opensaml.xacml.policy.AttributeAssignmentType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObligationWizard {
    private List<AttributeWizard> attributeWizardList;
    private ObligationType obligation = null;
    private String obligationId = null;

    public ObligationWizard(String obligationId) {
        this(obligationId, new LinkedList<AttributeWizard>());
    }

    public ObligationWizard(String obligationId, List<AttributeWizard> attributeWizardList) {
        this.attributeWizardList = attributeWizardList == null ? new LinkedList<AttributeWizard>() : attributeWizardList;
        this.obligationId = obligationId;
    }

    public ObligationWizard(ObligationType obligation) {
        this.obligationId = obligation.getObligationId();
        this.attributeWizardList = new LinkedList<AttributeWizard>();
        for (AttributeAssignmentType attributeAssignment : obligation.getAttributeAssignments()) {
            this.attributeWizardList.add(new AttributeWizard(attributeAssignment));
        }
    }

    public void addAttributeAssignment(AttributeWizard attributeWizard) {
        this.invalidateObligationType();
        this.attributeWizardList.add(attributeWizard);
    }

    public String getTagAndValue() {
        return String.format("obliagtion \"%s\"", this.obligation, this.obligationId);
    }

    public ObligationType getXACML() {
        this.initObligationTypeIfNotSet();
        return this.obligation;
    }

    public void releaseChildrenDOM() {
        this.releaseDOM();
    }

    public void releaseDOM() {
        if (this.obligation != null) {
            this.obligation.releaseChildrenDOM(true);
            this.obligation.releaseDOM();
        }
    }

    public String toFormattedString() {
        return this.toFormattedString(0, 4);
    }

    public String toFormattedString(int baseIndentation, int internalIndentation) {
        String baseIndentString = Utils.fillWithSpaces(baseIndentation);
        String indentString = Utils.fillWithSpaces(baseIndentation + internalIndentation);
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("%sobligation \"%s\" {\n", baseIndentString, this.obligationId));
        for (AttributeWizard attributeWizard : this.attributeWizardList) {
            sb.append(indentString + attributeWizard.toFormattedString() + "\n");
        }
        sb.append(baseIndentString + "}");
        return sb.toString();
    }

    private void initObligationTypeIfNotSet() {
        if (this.obligation == null) {
            this.setObligationType();
        }
    }

    private void invalidateObligationType() {
        this.obligation.releaseChildrenDOM(true);
        this.obligation.releaseDOM();
        this.obligation = null;
    }

    private void setObligationType() {
        this.releaseDOM();
        this.obligation = ObligationHelper.build(this.obligationId, EffectType.Permit);
        for (AttributeWizard attributeWizard : this.attributeWizardList) {
            ObligationHelper.addAttributeAssignment(this.obligation, attributeWizard.getXacmlId(), attributeWizard.getValue(), attributeWizard.getDataType());
        }
    }
}

