/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import org.glite.authz.pap.common.exceptions.PAPException;
import org.glite.authz.pap.common.xacml.utils.CtxAttributeTypeHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardType;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardTypeConfiguration;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedAttributeException;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.policy.AttributeAssignmentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeWizard {
    private static final Logger log = LoggerFactory.getLogger(AttributeWizard.class);
    private static final String X509_SUBJECT_DATA_TYPE = "urn:oasis:names:tc:xacml:1.0:data-type:x500Name";
    private AttributeWizardType attributeWizardType;
    private AttributeWizardTypeConfiguration attributeWizardTypeConfiguration = AttributeWizardTypeConfiguration.getInstance();
    private String value;

    public AttributeWizard(AttributeAssignmentType attributeAssignment) {
        String xacmlId = attributeAssignment.getAttributeId();
        try {
            this.attributeWizardType = this.attributeWizardTypeConfiguration.getByXACMLId(xacmlId);
        }
        catch (UnsupportedAttributeException e) {
            this.attributeWizardType = this.attributeWizardTypeConfiguration.getUnrecognizedAttributeWizard(xacmlId, attributeAssignment.getDataType());
        }
        this.value = attributeAssignment.getValue();
    }

    public AttributeWizard(AttributeType attribute) {
        String xacmlId = attribute.getAttributeID();
        try {
            this.attributeWizardType = this.attributeWizardTypeConfiguration.getByXACMLId(xacmlId);
        }
        catch (UnsupportedAttributeException e) {
            this.attributeWizardType = this.attributeWizardTypeConfiguration.getUnrecognizedAttributeWizard(xacmlId, attribute.getDataType());
        }
        this.value = CtxAttributeTypeHelper.getFirstValue(attribute);
    }

    public AttributeWizard(AttributeWizardType attributeWizardType, String value) {
        this.attributeWizardType = attributeWizardType;
        this.setValue(value);
    }

    public AttributeWizard(String idEqualValue) {
        int index = idEqualValue.indexOf(61);
        if (index == -1) {
            throw new UnsupportedAttributeException("invalid \"id=value\" string: " + idEqualValue);
        }
        String id = idEqualValue.substring(0, index);
        String value = idEqualValue.substring(index + 1);
        this.attributeWizardType = this.attributeWizardTypeConfiguration.getById(id);
        if (this.attributeWizardType == null) {
            throw new UnsupportedAttributeException("id=" + id);
        }
        this.setValue(value);
    }

    public AttributeWizard(String identifier, String value) {
        this.attributeWizardType = this.attributeWizardTypeConfiguration.getById(identifier);
        if (this.attributeWizardType == null) {
            throw new UnsupportedAttributeException("id=" + identifier);
        }
        this.setValue(value);
    }

    public static boolean isActionAttribute(AttributeType attribute) {
        String xacmlId = attribute.getAttributeID();
        return AttributeWizardTypeConfiguration.getInstance().xacmlIdMatchesTargetElement(xacmlId, AttributeWizardType.TargetElement.ACTION);
    }

    public static boolean isEnvironmentAttribute(AttributeType attribute) {
        String xacmlId = attribute.getAttributeID();
        return AttributeWizardTypeConfiguration.getInstance().xacmlIdMatchesTargetElement(xacmlId, AttributeWizardType.TargetElement.ENVIRONMENT);
    }

    public static boolean isResouceAttribute(AttributeType attribute) {
        String xacmlId = attribute.getAttributeID();
        return AttributeWizardTypeConfiguration.getInstance().xacmlIdMatchesTargetElement(xacmlId, AttributeWizardType.TargetElement.RESOURCE);
    }

    public static boolean isSubjectAttribute(AttributeType attribute) {
        String xacmlId = attribute.getAttributeID();
        return AttributeWizardTypeConfiguration.getInstance().xacmlIdMatchesTargetElement(xacmlId, AttributeWizardType.TargetElement.SUBJECT);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttributeWizard)) {
            log.trace("equals(): false. Not an AttributeWizard: " + object.getClass().getName());
            return false;
        }
        AttributeWizard attributeWizard = (AttributeWizard)object;
        if (!this.attributeWizardType.equals(attributeWizard.getAttributeWizardType())) {
            return false;
        }
        if (!this.value.equals(attributeWizard.getValue())) {
            log.trace("equals(): false. value1=" + this.value + " value2=" + attributeWizard.getValue());
            return false;
        }
        return true;
    }

    public AttributeWizardType getAttributeWizardType() {
        return this.attributeWizardType;
    }

    public String getDataType() {
        return this.attributeWizardType.getDataType();
    }

    public String getId() {
        return this.attributeWizardType.getId();
    }

    public String getMatchfunction() {
        return this.attributeWizardType.getMatchFunction();
    }

    public String getMatchFunctionDataType() {
        return this.attributeWizardType.getMatchFunctionDataType();
    }

    public AttributeWizardType.TargetElement getTargetElementType() {
        return this.attributeWizardType.getTargetElement();
    }

    public String getValue() {
        return this.value;
    }

    public AttributeType getXACML() {
        return CtxAttributeTypeHelper.build(this.attributeWizardType.getXacmlId(), this.attributeWizardType.getDataType(), this.value);
    }

    public String getXacmlId() {
        return this.attributeWizardType.getXacmlId();
    }

    public boolean isActionAttribute() {
        return AttributeWizardType.TargetElement.ACTION.equals((Object)this.attributeWizardType.getTargetElement());
    }

    public boolean isEnvironmentAttribute() {
        return AttributeWizardType.TargetElement.ENVIRONMENT.equals((Object)this.attributeWizardType.getTargetElement());
    }

    public boolean isResourceAttribute() {
        return AttributeWizardType.TargetElement.RESOURCE.equals((Object)this.attributeWizardType.getTargetElement());
    }

    public boolean isSubjectAttribute() {
        return AttributeWizardType.TargetElement.SUBJECT.equals((Object)this.attributeWizardType.getTargetElement());
    }

    public String toFormattedString() {
        return this.attributeWizardType.getId() + "=\"" + this.value + "\"";
    }

    private void setValue(String value) {
        String rfcDN = null;
        if (this.attributeWizardType.getDataType().equals(X509_SUBJECT_DATA_TYPE)) {
            try {
                rfcDN = value.startsWith("/") ? OpensslNameUtils.opensslToRfc2253((String)value) : value;
            }
            catch (IllegalArgumentException e) {
                throw new PAPException("The string passed as argument is not a valid certificate subject!", e);
            }
        }
        this.value = value;
    }
}

