/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glite.authz.pap.common.exceptions.XMLObjectException;
import org.glite.authz.pap.common.exceptions.XMLObjectMarshallingException;
import org.glite.authz.pap.common.exceptions.XMLObjectParserException;
import org.glite.authz.pap.common.exceptions.XMLObjectUnmarshallingException;
import org.glite.authz.pap.common.xacml.impl.PolicySetTypeString;
import org.glite.authz.pap.common.xacml.impl.PolicyTypeString;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLObjectHelper<T extends XMLObject> {
    protected static final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    private static final Object lock = new Object();

    protected XMLObjectHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLObject axisUnmarshall(Element element) throws UnmarshallingException {
        Object object = lock;
        synchronized (object) {
            Object xmlObject;
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            XMLObject xmlObjectDOM = unmarshaller.unmarshall(element);
            if (xmlObjectDOM instanceof PolicyType) {
                xmlObject = new PolicyTypeString((PolicyType)xmlObjectDOM);
                xmlObject.releaseDOM();
            } else if (xmlObjectDOM instanceof PolicySetType) {
                xmlObject = new PolicySetTypeString((PolicySetType)xmlObjectDOM);
                xmlObject.releaseDOM();
            } else {
                xmlObject = xmlObjectDOM;
            }
            return xmlObject;
        }
    }

    public static XMLObject buildXMLObject(Element element) {
        XMLObject xmlObject;
        try {
            xmlObject = XMLObjectHelper.unmarshall(element);
        }
        catch (UnmarshallingException e) {
            throw new XMLObjectUnmarshallingException(e);
        }
        return xmlObject;
    }

    public static XMLObject buildXMLObject(InputStream inputStream) {
        Document doc = XMLObjectHelper.readDocument(inputStream);
        return XMLObjectHelper.buildXMLObject(doc.getDocumentElement());
    }

    public static XMLObject buildXMLObjectFromFile(File file) {
        Document doc = XMLObjectHelper.readDocument(file);
        return XMLObjectHelper.buildXMLObject(doc.getDocumentElement());
    }

    public static XMLObject buildXMLObjectFromFile(String fileName) {
        return XMLObjectHelper.buildXMLObjectFromFile(new File(fileName));
    }

    public static Element getDOM(XMLObject xmlObject) {
        Element element;
        try {
            element = XMLObjectHelper.marshall(xmlObject);
        }
        catch (MarshallingException e) {
            throw new XMLObjectMarshallingException(e);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element marshall(XMLObject xmlObject) throws MarshallingException {
        Element element;
        Object object = lock;
        synchronized (object) {
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            element = marshaller.marshall(xmlObject);
        }
        return element;
    }

    public static void toFile(File file, XMLObject xmlObject) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new XMLObjectException("Cannot write to file: " + file.getAbsolutePath(), e);
        }
        XMLObjectHelper.write(fos, xmlObject, 4);
    }

    public static void toFile(String fileName, XMLObject xmlObject) {
        File file = new File(fileName);
        XMLObjectHelper.toFile(file, xmlObject);
    }

    public static String toString(Element element) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLObjectHelper.write(bos, element);
        return bos.toString();
    }

    public static String toString(XMLObject xmlObject) {
        return XMLObjectHelper.toString(xmlObject, 4);
    }

    public static String toString(XMLObject xmlObject, int indent) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLObjectHelper.write(bos, xmlObject, indent);
        return bos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLObject unmarshall(Element element) throws UnmarshallingException {
        Object object = lock;
        synchronized (object) {
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            XMLObject xmlObject = unmarshaller.unmarshall(element);
            return xmlObject;
        }
    }

    public static void write(OutputStream outputStream, Element element) {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("method", "xml");
            tr.transform(new DOMSource(element), new StreamResult(outputStream));
        }
        catch (TransformerConfigurationException e) {
            throw new XMLObjectException(e);
        }
        catch (TransformerException e) {
            throw new XMLObjectException(e);
        }
    }

    public static void write(OutputStream outputStream, XMLObject xmlObject, int indent) {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            tr.transform(new DOMSource(XMLObjectHelper.getDOM(xmlObject)), new StreamResult(outputStream));
        }
        catch (TransformerConfigurationException e) {
            throw new XMLObjectException(e);
        }
        catch (TransformerException e) {
            throw new XMLObjectException(e);
        }
    }

    private static Document readDocument(File file) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new XMLObjectException("File not found: " + file.getAbsolutePath(), e);
        }
        return XMLObjectHelper.readDocument(fileInputStream);
    }

    private static Document readDocument(InputStream inputStream) {
        Document doc;
        try {
            BasicParserPool ppMgr = new BasicParserPool();
            ppMgr.setNamespaceAware(true);
            doc = ppMgr.parse(inputStream);
        }
        catch (XMLParserException e) {
            throw new XMLObjectParserException(e);
        }
        return doc;
    }

    private static Document readDocument(Reader reader) {
        Document doc;
        try {
            BasicParserPool ppMgr = new BasicParserPool();
            ppMgr.setNamespaceAware(true);
            doc = ppMgr.parse(reader);
        }
        catch (XMLParserException e) {
            throw new XMLObjectException(e);
        }
        return doc;
    }

    public T build(Element element) {
        XMLObject xmlObject = XMLObjectHelper.buildXMLObject(element);
        return (T)xmlObject;
    }

    public T buildFromFile(File file) {
        Document doc = XMLObjectHelper.readDocument(file);
        return this.build(doc.getDocumentElement());
    }

    public T buildFromString(String s) {
        StringReader sr = new StringReader(s);
        Document doc = XMLObjectHelper.readDocument(sr);
        return this.build(doc.getDocumentElement());
    }

    public T clone(T xmlObject) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLObjectHelper.write(bos, xmlObject, 0);
        ByteArrayInputStream ios = new ByteArrayInputStream(bos.toByteArray());
        Document doc = XMLObjectHelper.readDocument(ios);
        return this.build(doc.getDocumentElement());
    }

    public String readFromFileAsString(File file) {
        T xmlObject = this.buildFromFile(file);
        return XMLObjectHelper.toString(xmlObject);
    }
}

