/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.utils;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.glite.authz.pap.common.xacml.utils.TargetHelper;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.RuleType;
import org.opensaml.xacml.policy.TargetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyHelper
extends XMLObjectHelper<PolicyType> {
    public static final String RULE_COMBALG_DENY_OVERRIDS = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:deny-overrides";
    public static final String RULE_COMBALG_FIRST_APPLICABLE = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable";
    public static final String RULE_COMBALG_PERMIT_OVERRIDS = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides";
    private static final QName ELEMENT_NAME = PolicyType.DEFAULT_ELEMENT_NAME;
    private static PolicyHelper instance = new PolicyHelper();

    private PolicyHelper() {
    }

    public static PolicyType build(String policyId, String ruleCombinerAlgorithmId) {
        return PolicyHelper.build(policyId, ruleCombinerAlgorithmId, null);
    }

    public static PolicyType build(String policyId, String ruleCombinerAlgorithmId, TargetType target) {
        PolicyType policy = (PolicyType)builderFactory.getBuilder(ELEMENT_NAME).buildObject(ELEMENT_NAME);
        policy.setPolicyId(policyId);
        policy.setRuleCombiningAlgoId(ruleCombinerAlgorithmId);
        if (target == null) {
            policy.setTarget(TargetHelper.build());
        } else {
            policy.setTarget(target);
        }
        return policy;
    }

    public static PolicyHelper getInstance() {
        return instance;
    }

    public static RuleType getRule(PolicyType policy, String ruleId) {
        if (ruleId == null) {
            return null;
        }
        for (RuleType rule : policy.getRules()) {
            if (!ruleId.equals(rule.getRuleId())) continue;
            return rule;
        }
        return null;
    }

    public static boolean hasRuleWithId(PolicyType policy, String ruleId) {
        if (ruleId == null) {
            return false;
        }
        List ruleList = policy.getRules();
        for (RuleType rule : ruleList) {
            if (!ruleId.equals(rule.getRuleId())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasObligationWithId(PolicyType policy, String obligationId) {
        if (obligationId == null) {
            return false;
        }
        if (policy.getObligations() == null) {
            return false;
        }
        for (ObligationType obligation : policy.getObligations().getObligations()) {
            if (!obligationId.equals(obligation.getObligationId())) continue;
            return true;
        }
        return false;
    }

    public static int indexOfRule(PolicyType policy, String ruleId) {
        if (ruleId == null) {
            return -1;
        }
        List ruleList = policy.getRules();
        for (int i = 0; i < ruleList.size(); ++i) {
            if (!ruleId.equals(((RuleType)ruleList.get(i)).getRuleId())) continue;
            return i;
        }
        return -1;
    }

    public static void addRule(PolicyType policy, int index, RuleType rule) {
        if (index == -1) {
            policy.getRules().add(rule);
            return;
        }
        ArrayList<RuleType> ruleList = new ArrayList<RuleType>(policy.getRules());
        ruleList.add(index, rule);
        policy.getRules().clear();
        policy.getRules().addAll(ruleList);
    }

    public static RuleType removeRule(PolicyType policy, String ruleId) {
        if (ruleId == null) {
            return null;
        }
        List ruleList = policy.getRules();
        RuleType targetRule = null;
        for (RuleType rule : ruleList) {
            if (!ruleId.equals(rule.getRuleId())) continue;
            targetRule = rule;
            break;
        }
        if (targetRule != null) {
            ruleList.remove(targetRule);
            return targetRule;
        }
        return null;
    }
}

