/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.impl;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.glite.authz.pap.common.xacml.utils.PolicyHelper;
import org.opensaml.xacml.policy.CombinerParametersType;
import org.opensaml.xacml.policy.DefaultsType;
import org.opensaml.xacml.policy.DescriptionType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.RuleCombinerParametersType;
import org.opensaml.xacml.policy.RuleType;
import org.opensaml.xacml.policy.TargetType;
import org.opensaml.xacml.policy.VariableDefinitionType;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyTypeString
implements PolicyType {
    private static final Logger log = LoggerFactory.getLogger(PolicyTypeString.class);
    private PolicyType policy = null;
    private String policyId = null;
    private String policyString = null;

    public PolicyTypeString(PolicyType policy) {
        this.policy = policy;
        this.policyId = policy.getPolicyId();
        this.policyString = null;
    }

    public PolicyTypeString(String policyString) {
        this.policyString = policyString;
    }

    public PolicyTypeString(String policyId, String policyString) {
        this.policyId = policyId;
        this.policyString = policyString;
    }

    public void addNamespace(Namespace arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.addNamespace(arg0);
        this.invalidatePolicyString();
    }

    public void deregisterValidator(Validator arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.deregisterValidator(arg0);
        this.invalidatePolicyString();
    }

    public void detach() {
        this.initPolicyTypeIfNotSet();
        this.policy.detach();
        this.invalidatePolicyString();
    }

    public List<CombinerParametersType> getCombinerParameters() {
        this.initPolicyTypeIfNotSet();
        this.invalidatePolicyString();
        return this.policy.getCombinerParameters();
    }

    public DescriptionType getDescription() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getDescription();
    }

    public Element getDOM() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getDOM();
    }

    public QName getElementQName() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getElementQName();
    }

    public IDIndex getIDIndex() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getIDIndex();
    }

    public Set<Namespace> getNamespaces() {
        this.initPolicyTypeIfNotSet();
        this.invalidatePolicyString();
        return this.policy.getNamespaces();
    }

    public String getNoNamespaceSchemaLocation() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getNoNamespaceSchemaLocation();
    }

    public ObligationsType getObligations() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getObligations();
    }

    public List<XMLObject> getOrderedChildren() {
        this.initPolicyTypeIfNotSet();
        this.invalidatePolicyString();
        return this.policy.getOrderedChildren();
    }

    public XMLObject getParent() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getParent();
    }

    public DefaultsType getPolicyDefaults() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getPolicyDefaults();
    }

    public String getPolicyId() {
        if (this.policyId == null) {
            this.initPolicyTypeIfNotSet();
        }
        log.trace("get policyId: " + this.policyId);
        return this.policyId;
    }

    public String getPolicyString() {
        this.initPolicyStringIfNotSet();
        return this.policyString;
    }

    public List<RuleCombinerParametersType> getRuleCombinerParameters() {
        this.initPolicyTypeIfNotSet();
        this.invalidatePolicyString();
        return this.policy.getRuleCombinerParameters();
    }

    public String getRuleCombiningAlgoId() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getRuleCombiningAlgoId();
    }

    public List<RuleType> getRules() {
        this.initPolicyTypeIfNotSet();
        this.invalidatePolicyString();
        return this.policy.getRules();
    }

    public String getSchemaLocation() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getSchemaLocation();
    }

    public QName getSchemaType() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getSchemaType();
    }

    public TargetType getTarget() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getTarget();
    }

    public List<Validator> getValidators() {
        this.initPolicyTypeIfNotSet();
        this.invalidatePolicyString();
        return this.policy.getValidators();
    }

    public List<VariableDefinitionType> getVariableDefinitions() {
        this.initPolicyTypeIfNotSet();
        this.invalidatePolicyString();
        return this.policy.getVariableDefinitions();
    }

    public String getVersion() {
        this.initPolicyTypeIfNotSet();
        return this.policy.getVersion();
    }

    public boolean hasChildren() {
        this.initPolicyTypeIfNotSet();
        return this.policy.hasChildren();
    }

    public boolean hasParent() {
        this.initPolicyTypeIfNotSet();
        return this.policy.hasParent();
    }

    public boolean isDOMLoaded() {
        return this.policy != null;
    }

    public void registerValidator(Validator arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.registerValidator(arg0);
        this.invalidatePolicyString();
    }

    public void releaseChildrenDOM(boolean arg0) {
        this.releaseDOM();
    }

    public synchronized void releaseDOM() {
        if (this.policy != null) {
            this.initPolicyStringIfNotSet();
            log.trace("Invalidating policyType");
            this.policy.releaseChildrenDOM(true);
            this.policy.releaseDOM();
            this.policy = null;
        }
    }

    public void releaseParentDOM(boolean arg0) {
        if (this.policy != null) {
            this.policy.releaseParentDOM(arg0);
        }
    }

    public void removeNamespace(Namespace arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.removeNamespace(arg0);
        this.invalidatePolicyString();
    }

    public XMLObject resolveID(String arg0) {
        this.initPolicyTypeIfNotSet();
        return this.policy.resolveID(arg0);
    }

    public XMLObject resolveIDFromRoot(String arg0) {
        this.initPolicyTypeIfNotSet();
        return this.policy.resolveIDFromRoot(arg0);
    }

    public void setDescription(DescriptionType arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setDescription(arg0);
        this.invalidatePolicyString();
    }

    public void setDOM(Element arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setDOM(arg0);
        this.policyId = this.policy.getPolicyId();
        this.invalidatePolicyString();
    }

    public void setNoNamespaceSchemaLocation(String arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setNoNamespaceSchemaLocation(arg0);
        this.invalidatePolicyString();
    }

    public void setObligations(ObligationsType arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setObligations(arg0);
        this.invalidatePolicyString();
    }

    public void setParent(XMLObject arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setParent(arg0);
        this.invalidatePolicyString();
    }

    public void setPolicyDefaults(DefaultsType arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setPolicyDefaults(arg0);
        this.invalidatePolicyString();
    }

    public void setPolicyId(String arg0) {
        log.trace("Setting policyId");
        this.initPolicyTypeIfNotSet();
        this.policyId = arg0;
        this.policy.setPolicyId(arg0);
        this.invalidatePolicyString();
    }

    public void setPolicyString(String policyString) {
        this.policyString = policyString;
        this.invalidatePolicyId();
        this.releaseDOM();
    }

    public void setPolicyString(String policyId, String policyString) {
        this.policyString = policyString;
        this.policyId = policyId;
        this.releaseDOM();
    }

    public void setRuleCombiningAlgoId(String arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setRuleCombiningAlgoId(arg0);
        this.invalidatePolicyString();
    }

    public void setSchemaLocation(String arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setSchemaLocation(arg0);
        this.invalidatePolicyString();
    }

    public void setTarget(TargetType arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setTarget(arg0);
        this.invalidatePolicyString();
    }

    public void setVersion(String arg0) {
        this.initPolicyTypeIfNotSet();
        this.policy.setVersion(arg0);
        this.invalidatePolicyString();
    }

    public void validate(boolean arg0) throws ValidationException {
        this.initPolicyTypeIfNotSet();
        this.policy.validate(arg0);
    }

    private void initPolicyStringIfNotSet() {
        if (this.policyString == null) {
            log.trace("Initializing policyString");
            this.policyString = PolicyHelper.toString((XMLObject)this.policy);
            this.policyId = this.policy.getPolicyId();
        }
    }

    private synchronized void initPolicyTypeIfNotSet() {
        if (this.policy == null) {
            log.trace("Initializing policyType");
            this.policy = (PolicyType)PolicyHelper.getInstance().buildFromString(this.policyString);
            this.policyId = this.policy.getPolicyId();
        }
    }

    private void invalidatePolicyId() {
        log.trace("Invalidating policyId");
        this.policyId = null;
    }

    private void invalidatePolicyString() {
        log.trace("Invalidating policyString");
        this.policyString = null;
    }
}

