/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.impl;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.glite.authz.pap.common.xacml.utils.PolicyHelper;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.opensaml.xacml.XACMLObject;
import org.opensaml.xacml.policy.CombinerParametersType;
import org.opensaml.xacml.policy.DefaultsType;
import org.opensaml.xacml.policy.DescriptionType;
import org.opensaml.xacml.policy.IdReferenceType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.policy.PolicyCombinerParametersType;
import org.opensaml.xacml.policy.PolicySetCombinerParametersType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.TargetType;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetTypeString
implements PolicySetType {
    private static final Logger log = LoggerFactory.getLogger(PolicySetTypeString.class);
    private PolicySetType policySet = null;
    private String policySetId = null;
    private String policySetString = null;

    public PolicySetTypeString(PolicySetType policySet) {
        this.policySet = policySet;
        this.policySetId = policySet.getPolicySetId();
    }

    public PolicySetTypeString(String policySetString) {
        this.policySetString = policySetString;
    }

    public PolicySetTypeString(String policySetId, String policySetString) {
        this(policySetString);
        this.policySetId = policySetId;
    }

    public void addNamespace(Namespace arg0) {
        this.initPolicySetTypeIfNotSet();
        this.policySet.addNamespace(arg0);
        this.invalidatePolicySetString();
    }

    public void deregisterValidator(Validator arg0) {
        this.initPolicySetTypeIfNotSet();
        this.policySet.deregisterValidator(arg0);
        this.invalidatePolicySetString();
    }

    public void detach() {
        this.initPolicySetTypeIfNotSet();
        this.policySet.detach();
        this.invalidatePolicySetString();
    }

    public List<CombinerParametersType> getCombinerParameters() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getCombinerParameters();
    }

    public DescriptionType getDescription() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getDescription();
    }

    public Element getDOM() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getDOM();
    }

    public QName getElementQName() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getElementQName();
    }

    public IDIndex getIDIndex() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getIDIndex();
    }

    public Set<Namespace> getNamespaces() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getNamespaces();
    }

    public String getNoNamespaceSchemaLocation() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getNoNamespaceSchemaLocation();
    }

    public ObligationsType getObligations() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getObligations();
    }

    public List<XMLObject> getOrderedChildren() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getOrderedChildren();
    }

    public XMLObject getParent() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getParent();
    }

    public List<PolicyType> getPolicies() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getPolicies();
    }

    public IndexedXMLObjectChildrenList<XACMLObject> getPolicyChoiceGroup() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getPolicyChoiceGroup();
    }

    public List<PolicyCombinerParametersType> getPolicyCombinerParameters() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getPolicyCombinerParameters();
    }

    public String getPolicyCombiningAlgoId() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getPolicyCombiningAlgoId();
    }

    public List<IdReferenceType> getPolicyIdReferences() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getPolicyIdReferences();
    }

    public List<PolicySetCombinerParametersType> getPolicySetCombinerParameters() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getPolicySetCombinerParameters();
    }

    public DefaultsType getPolicySetDefaults() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getPolicySetDefaults();
    }

    public String getPolicySetId() {
        if (this.policySetId == null) {
            log.trace("getPolicySetId(): PolicySetId is not set, need to build the DOM");
            this.initPolicySetTypeIfNotSet();
        }
        return this.policySetId;
    }

    public List<IdReferenceType> getPolicySetIdReferences() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getPolicySetIdReferences();
    }

    public List<PolicySetType> getPolicySets() {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        return this.policySet.getPolicySets();
    }

    public String getPolicySetString() {
        this.initPolicySetStringIfNotSet();
        return this.policySetString;
    }

    public String getSchemaLocation() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getSchemaLocation();
    }

    public QName getSchemaType() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getSchemaType();
    }

    public TargetType getTarget() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getTarget();
    }

    public List<Validator> getValidators() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getValidators();
    }

    public String getVersion() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.getVersion();
    }

    public boolean hasChildren() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.hasChildren();
    }

    public boolean hasParent() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.hasParent();
    }

    public boolean isDOMLoaded() {
        return this.policySet != null;
    }

    public void registerValidator(Validator arg0) {
        this.initPolicySetTypeIfNotSet();
        this.policySet.registerValidator(arg0);
    }

    public void releaseChildrenDOM(boolean arg0) {
        this.releaseDOM();
    }

    public synchronized void releaseDOM() {
        if (this.policySet != null) {
            this.initPolicySetStringIfNotSet();
            log.trace("Invalidating policySetType");
            this.policySet.releaseChildrenDOM(true);
            this.policySet.releaseDOM();
            this.policySet = null;
        }
    }

    public void releaseParentDOM(boolean arg0) {
        if (this.policySet != null) {
            this.policySet.releaseParentDOM(arg0);
        }
    }

    public void removeNamespace(Namespace arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.removeNamespace(arg0);
    }

    public XMLObject resolveID(String arg0) {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.resolveID(arg0);
    }

    public XMLObject resolveIDFromRoot(String arg0) {
        this.initPolicySetTypeIfNotSet();
        return this.policySet.resolveIDFromRoot(arg0);
    }

    public void setDescription(DescriptionType arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.setDescription(arg0);
    }

    public void setDOM(Element arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.setDOM(arg0);
    }

    public void setNoNamespaceSchemaLocation(String arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.setNoNamespaceSchemaLocation(arg0);
    }

    public void setObligations(ObligationsType arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.setObligations(arg0);
    }

    public void setParent(XMLObject arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.setParent(arg0);
    }

    public void setPolicyCombiningAlgoId(String arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.setPolicyCombiningAlgoId(arg0);
    }

    public void setPolicySetDefaults(DefaultsType arg0) {
        this.initPolicySetTypeIfNotSet();
        this.invalidatePolicySetString();
        this.policySet.setPolicySetDefaults(arg0);
    }

    public void setPolicySetId(String arg0) {
        this.initPolicySetTypeIfNotSet();
        this.policySet.setPolicySetId(arg0);
        this.policySetId = arg0;
        this.invalidatePolicySetString();
    }

    public void setPolicySetString(String policySetString) {
        this.policySetString = policySetString;
        this.invalidatePolicySetId();
        this.releaseDOM();
    }

    public void setPolicySetString(String policySetId, String policySetString) {
        this.policySetString = policySetString;
        this.policySetId = policySetId;
        this.invalidatePolicySetId();
        this.releaseDOM();
    }

    public void setSchemaLocation(String arg0) {
        this.initPolicySetTypeIfNotSet();
        this.policySet.setSchemaLocation(arg0);
        this.invalidatePolicySetString();
    }

    public void setTarget(TargetType arg0) {
        this.initPolicySetTypeIfNotSet();
        this.policySet.setTarget(arg0);
        this.invalidatePolicySetString();
    }

    public void setVersion(String arg0) {
        this.initPolicySetTypeIfNotSet();
        this.policySet.setVersion(arg0);
        this.invalidatePolicySetString();
    }

    public void validate(boolean arg0) throws ValidationException {
        this.initPolicySetTypeIfNotSet();
        this.policySet.validate(arg0);
    }

    private void initPolicySetStringIfNotSet() {
        if (this.policySetString == null) {
            log.trace("Initializing policySetString id=" + this.policySet.getPolicySetId());
            this.policySetString = PolicyHelper.toString((XMLObject)this.policySet);
            this.policySetId = this.policySet.getPolicySetId();
        }
    }

    private synchronized void initPolicySetTypeIfNotSet() {
        if (this.policySet == null) {
            this.policySet = (PolicySetType)PolicySetHelper.getInstance().buildFromString(this.policySetString);
            this.policySetId = this.policySet.getPolicySetId();
            log.trace("Initializing policySetType id=" + this.policySetId);
        }
    }

    private void invalidatePolicySetId() {
        log.trace("Invalidating policySetId");
        this.policySetId = null;
    }

    private void invalidatePolicySetString() {
        log.trace("Invalidating policySetString");
        this.policySetString = null;
    }
}

