/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.opensamlserializer;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.wsdl.fromJava.Types;
import org.glite.authz.pap.common.xacml.impl.PolicySetTypeString;
import org.glite.authz.pap.common.xacml.impl.PolicyTypeString;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class Serializer
implements org.apache.axis.encoding.Serializer {
    private static final long serialVersionUID = -4207218164610553717L;
    private static final Logger log = LoggerFactory.getLogger(Serializer.class);

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        try {
            String elementAsString;
            if (value instanceof PolicyTypeString) {
                elementAsString = ((PolicyTypeString)value).getPolicyString();
            } else if (value instanceof PolicySetTypeString) {
                elementAsString = ((PolicySetTypeString)value).getPolicySetString();
            } else {
                XMLObject xmlObject = (XMLObject)value;
                Element element = XMLObjectHelper.marshall(xmlObject);
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        element.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
                    }
                }
                elementAsString = XMLObjectHelper.toString(element);
                xmlObject.releaseChildrenDOM(true);
                xmlObject.releaseDOM();
            }
            int index = elementAsString.indexOf("?>");
            String element = index != -1 ? elementAsString.substring(index + 2) : elementAsString;
            context.setWriteXMLType(null);
            context.writeString(element);
        }
        catch (Exception exception) {
            throw new IOException("Error serializing " + value.getClass().getName() + " : " + exception.getClass().getName());
        }
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        Element complexType = types.createElement("complexType");
        return complexType;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }
}

