/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common;

import java.io.Serializable;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pap
implements Serializable {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PAP_ALIAS = "default";
    public static final String DEFAULT_PORT = "8150";
    public static final String DEFAULT_PROTOCOL = "https";
    public static final String DEFAULT_SERVICES_ROOT_PATH = "/pap/services/";
    private static final Logger log = LoggerFactory.getLogger(Pap.class);
    private String alias = null;
    private String dn = null;
    private String hostname = null;
    private String id = null;
    private String path = null;
    private long policyLastModificationTimeInMillis = 0L;
    private String port = null;
    private String protocol = null;
    private boolean local = true;
    private boolean visibilityPublic = false;
    private boolean enabled = false;

    public Pap() {
    }

    public Pap(String alias, boolean isLocal, String dn, String hostname, String port, String servicesRootPath, String protocol, boolean visibilityPublic) {
        assert (alias != null && alias.length() > 0) : "alias cannot be null or empty";
        this.alias = alias;
        this.visibilityPublic = visibilityPublic;
        this.local = isLocal;
        this.dn = dn;
        this.id = WizardUtils.generateId(alias);
        this.hostname = Utils.isDefined(hostname) ? hostname : DEFAULT_HOST;
        this.port = Utils.isDefined(port) ? port : DEFAULT_PORT;
        this.path = Utils.isDefined(servicesRootPath) ? servicesRootPath : DEFAULT_SERVICES_ROOT_PATH;
        this.protocol = Utils.isDefined(protocol) ? protocol : DEFAULT_PROTOCOL;
    }

    public static boolean isLocal(String type) {
        return "local".equals(type.toLowerCase());
    }

    public static Pap makeDefaultPAP() {
        Pap defaultPap = new Pap(DEFAULT_PAP_ALIAS, true, null, null, null, null, null, true);
        defaultPap.setEnabled(true);
        return defaultPap;
    }

    public boolean equals(Pap pap) {
        if (pap == null) {
            return false;
        }
        if (!this.alias.equals(pap.getAlias())) {
            return false;
        }
        if (this.local != pap.isLocal()) {
            return false;
        }
        if (this.visibilityPublic != pap.isVisibilityPublic()) {
            return false;
        }
        if (this.dn != null ? !this.dn.equals(pap.getDn()) : pap.getDn() != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(pap.getHostname()) : pap.getHostname() != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(pap.getPort()) : pap.getPort() != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(pap.getPath()) : pap.getPath() != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals(pap.getProtocol()) : pap.getProtocol() != null);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDn() {
        return this.dn;
    }

    public String getEndpoint() {
        return this.protocol + "://" + this.hostname + ":" + this.port + this.path;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getPolicyLastModificationTimeInMilliseconds() {
        return String.valueOf(this.policyLastModificationTimeInMillis);
    }

    public String getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getTypeAsString() {
        if (this.local) {
            return "local";
        }
        return "remote";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isRemote() {
        return !this.local;
    }

    public boolean isVisibilityPublic() {
        return this.visibilityPublic;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setId(String papId) {
        this.id = papId;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPolicyLastModificationTime(long milliseconds) {
        this.policyLastModificationTimeInMillis = milliseconds;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPublic(boolean isPublic) {
        this.visibilityPublic = isPublic;
    }

    public void setVisibilityPublic(boolean visibilityPublic) {
        this.visibilityPublic = visibilityPublic;
    }

    public String toFormattedString() {
        return this.toFormattedString(0, 4);
    }

    public String toFormattedString(int indent) {
        return this.toFormattedString(indent, 4);
    }

    public String toFormattedString(int indent, int padding) {
        String indentString = Utils.fillWithSpaces(indent);
        String paddingString = Utils.fillWithSpaces(indent + padding);
        String visibility = this.visibilityPublic ? "public" : "private";
        String aliasString = String.format("%salias=%s\n", indentString, this.alias);
        String typeString = String.format("%sisLocal=%b\n", paddingString, this.local);
        String visibilityString = String.format("%svisibility=%s\n", paddingString, visibility);
        String enabledString = String.format("%senabled=%b\n", paddingString, this.enabled);
        String dnString = String.format("%sdn=%s\n", paddingString, this.dn);
        String endpointString = String.format("%sendpoint=%s\n", paddingString, this.getEndpoint());
        if (this.local) {
            if (this.dn == null) {
                dnString = "";
            }
            if (this.hostname == null && this.port == null) {
                endpointString = "";
            }
        }
        return aliasString + typeString + visibilityString + enabledString + dnString + endpointString;
    }

    public String toString() {
        String visibility = this.visibilityPublic ? "public" : "private";
        return String.format("alias=\"%s\" isLocal=\"%b\" visibility=\"%s\" enabled=\"%b\" dn=\"%s\" endpoint=\"%s\" id=\"%s\"", this.alias, this.local, visibility, this.enabled, this.dn, this.getEndpoint(), this.id);
    }
}

