/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.client.impl.axis;

import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.HostnameMismatchCallback;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SecureSocketFactory;
import org.glite.authz.pap.client.impl.axis.CANLAxis1SocketFactoryConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CANLAxis1SocketFactory
implements SecureSocketFactory,
HostnameMismatchCallback,
ValidationErrorListener {
    public static final Logger log = LoggerFactory.getLogger((String)CANLAxis1SocketFactory.class.getName());
    private String sslProtocol;
    private String certFile;
    private String keyFile;
    private String keyPassword;
    private String proxyFile;
    private int timeout;
    private boolean enforcingHostnameChecks;
    private String secureRandomAlgorithm;
    private X509CertChainValidatorExt certChainValidator;
    private static CANLAxis1SocketFactoryConfigurator configurator;

    public CANLAxis1SocketFactory(Hashtable attributes) {
        CertificateUtils.configureSecProvider();
        configurator.configure(this);
    }

    public static synchronized void setConfigurator(CANLAxis1SocketFactoryConfigurator conf) {
        configurator = conf;
    }

    private KeyManager[] getKeymanagers() throws Exception {
        PEMCredential cred = this.proxyFile != null ? new PEMCredential((InputStream)new FileInputStream(this.proxyFile), (char[])null) : (this.keyPassword != null ? new PEMCredential(this.keyFile, this.certFile, this.keyPassword.toCharArray()) : new PEMCredential(this.keyFile, this.certFile, null));
        return new KeyManager[]{cred.getKeyManager()};
    }

    private TrustManager[] getTrustmanagers() throws Exception {
        X509TrustManager trustManager = SocketFactoryCreator.getSSLTrustManager((X509CertChainValidator)this.certChainValidator);
        TrustManager[] trustManagers = new TrustManager[]{trustManager};
        return trustManagers;
    }

    private SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return new SecureRandom();
    }

    private SSLSocketFactory createSocketFactory() throws Exception {
        SSLContext context = SSLContext.getInstance(this.sslProtocol);
        KeyManager[] keyManagers = this.getKeymanagers();
        TrustManager[] trustManagers = this.getTrustmanagers();
        SecureRandom random = this.getSecureRandom();
        context.init(keyManagers, trustManagers, random);
        return context.getSocketFactory();
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        SSLSocketFactory fac = this.createSocketFactory();
        SSLSocket socket = (SSLSocket)fac.createSocket(host, port);
        socket.setEnabledProtocols(new String[]{this.sslProtocol});
        socket.setSoTimeout(this.timeout);
        SocketFactoryCreator.connectWithHostnameChecking((SSLSocket)socket, (HostnameMismatchCallback)this);
        return socket;
    }

    public void nameMismatch(SSLSocket socket, X509Certificate peerCertificate, String hostName) throws SSLException {
        if (this.enforcingHostnameChecks) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            String peerCertificateSubject = X500NameUtils.getReadableForm((X500Principal)peerCertificate.getSubjectX500Principal());
            String message = String.format("Peer certificate subject %s does not match hostname %s", peerCertificateSubject, hostName);
            throw new SSLException(message);
        }
    }

    public boolean onValidationError(ValidationError error) {
        log.error("Certificate validation error: {}", (Object)error);
        return false;
    }

    public synchronized void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public synchronized void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public synchronized void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public synchronized void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public synchronized void setProxyFile(String proxyFile) {
        this.proxyFile = proxyFile;
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized void setEnforcingHostnameChecks(boolean enforcingHostnameChecks) {
        this.enforcingHostnameChecks = enforcingHostnameChecks;
    }

    public synchronized void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public synchronized X509CertChainValidatorExt getCertChainValidator() {
        return this.certChainValidator;
    }

    public synchronized void setCertChainValidator(X509CertChainValidatorExt certChainValidator) {
        this.certChainValidator = certChainValidator;
    }
}

