/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.client.impl;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.axis.AxisProperties;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.authz.pap.client.ServiceClient;
import org.glite.authz.pap.client.impl.ProvisioningServiceLocator;
import org.glite.authz.pap.client.impl.axis.CANLAxis1SocketFactory;
import org.glite.authz.pap.client.impl.axis.DefaultConfigurator;
import org.glite.authz.pap.common.exceptions.PAPException;
import org.glite.authz.pap.common.opensamlserializer.DeserializerFactory;
import org.glite.authz.pap.common.opensamlserializer.PolicySetTypeDeserializerFactory;
import org.glite.authz.pap.common.opensamlserializer.PolicyTypeDeserializerFactory;
import org.glite.authz.pap.common.opensamlserializer.SerializerFactory;
import org.glite.authz.pap.services.authz_management.axis_skeletons.PAPAuthorizationManagement;
import org.glite.authz.pap.services.authz_management.axis_skeletons.PAPAuthorizationManagementServiceLocator;
import org.glite.authz.pap.services.highlevel_policy_management.axis_skeletons.HighLevelPolicyManagement;
import org.glite.authz.pap.services.highlevel_policy_management.axis_skeletons.HighLevelPolicyManagementServiceLocator;
import org.glite.authz.pap.services.pap_management.axis_skeletons.PAPManagement;
import org.glite.authz.pap.services.pap_management.axis_skeletons.PAPManagementServiceLocator;
import org.glite.authz.pap.services.provisioning.axis_skeletons.Provisioning;
import org.glite.authz.pap.services.xacml_policy_management.axis_skeletons.XACMLPolicyManagement;
import org.glite.authz.pap.services.xacml_policy_management.axis_skeletons.XACMLPolicyManagementServiceLocator;
import org.opensaml.saml2.core.Response;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.profile.saml.XACMLPolicyQueryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClientImplAxis
implements ServiceClient {
    public static final String AXIS_SOCKET_FACTORY_PROPERTY = "axis.socketSecureFactory";
    public final Logger log = LoggerFactory.getLogger(ServiceClientImplAxis.class);
    private String clientCertificate = null;
    private String clientPrivateKey = null;
    private String clientPrivateKeyPassword = null;
    private String clientProxy = null;
    private String serviceURL = null;
    private PasswordFinder passwordFinder = null;

    public ServiceClientImplAxis() {
    }

    public ServiceClientImplAxis(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getClientCertificate() {
        return this.clientCertificate;
    }

    public String getClientPrivateKey() {
        return this.clientPrivateKey;
    }

    public String getClientPrivateKeyPassword() {
        return this.clientPrivateKeyPassword;
    }

    public String getClientProxy() {
        return this.clientProxy;
    }

    public HighLevelPolicyManagement getHighLevelPolicyManagementService(String url) {
        this.initializeAxisProperties();
        HighLevelPolicyManagementServiceLocator loc = new HighLevelPolicyManagementServiceLocator();
        try {
            return loc.getHighLevelPolicyManagementService(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new PAPException("Error contacting Highlevel Policy management service: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new PAPException("Error contacting HighLevel Policy management service: " + e.getMessage(), e);
        }
    }

    public String getHighLevelPolicyManagementServiceName() {
        return "HighLevelPolicyManagementService";
    }

    public PAPAuthorizationManagement getPAPAuthorizationManagementService(String url) {
        this.initializeAxisProperties();
        PAPAuthorizationManagementServiceLocator loc = new PAPAuthorizationManagementServiceLocator();
        try {
            return loc.getPAPAuthorizationManagement(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new PAPException("Error contacting PAP Authorization management service: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new PAPException("Error contacting PAP Authorization management service: " + e.getMessage(), e);
        }
    }

    public String getPAPAuthorizationManagementServiceName() {
        return "AuthorizationManagementService";
    }

    public PAPManagement getPAPManagementService(String url) {
        this.initializeAxisProperties();
        PAPManagementServiceLocator loc = new PAPManagementServiceLocator();
        try {
            return loc.getPAPManagementService(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new PAPException("Error contacting PAP Management service: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new PAPException("Error contacting PAP Management service: " + e.getMessage(), e);
        }
    }

    public String getPAPManagementServiceName() {
        return "PAPManagementService";
    }

    public Provisioning getProvisioningService(String url) {
        this.initializeAxisProperties();
        ProvisioningServiceLocator loc = new ProvisioningServiceLocator();
        TypeMapping typeMapping = loc.getTypeMappingRegistry().getDefaultTypeMapping();
        typeMapping.register(XACMLPolicyQueryType.class, XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20, (javax.xml.rpc.encoding.SerializerFactory)new SerializerFactory(), (javax.xml.rpc.encoding.DeserializerFactory)new DeserializerFactory());
        typeMapping.register(Response.class, Response.DEFAULT_ELEMENT_NAME, (javax.xml.rpc.encoding.SerializerFactory)new SerializerFactory(), (javax.xml.rpc.encoding.DeserializerFactory)new DeserializerFactory());
        try {
            return loc.getProvisioningService(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new PAPException("Error contacting Provisioning Policy management service: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new PAPException("Error contacting Provisioning Policy management service: " + e.getMessage(), e);
        }
    }

    public String getProvisioningServiceName() {
        return "ProvisioningService";
    }

    public String getTargetEndpoint() {
        return this.serviceURL;
    }

    public XACMLPolicyManagement getXACMLPolicyManagementService(String url) {
        this.initializeAxisProperties();
        XACMLPolicyManagementServiceLocator loc = new XACMLPolicyManagementServiceLocator();
        TypeMapping typeMapping = loc.getTypeMappingRegistry().getDefaultTypeMapping();
        typeMapping.register(PolicyType.class, PolicyType.SCHEMA_TYPE_NAME, (javax.xml.rpc.encoding.SerializerFactory)new SerializerFactory(), (javax.xml.rpc.encoding.DeserializerFactory)new PolicyTypeDeserializerFactory());
        typeMapping.register(PolicySetType.class, PolicySetType.SCHEMA_TYPE_NAME, (javax.xml.rpc.encoding.SerializerFactory)new SerializerFactory(), (javax.xml.rpc.encoding.DeserializerFactory)new PolicySetTypeDeserializerFactory());
        try {
            return loc.getXACMLPolicyManagementService(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new PAPException("Error contacting XACML Policy management service: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new PAPException("Error contacting XACML Policy management service: " + e.getMessage(), e);
        }
    }

    public String getXACMLPolicyManagementServiceName() {
        return "XACMLPolicyManagementService";
    }

    public void setClientCertificate(String certFile) {
        this.log.debug("clientCertificate=" + certFile);
        this.clientCertificate = certFile;
    }

    public void setClientPrivateKey(String keyFile) {
        this.log.debug("clientPrivateKey=" + keyFile);
        this.clientPrivateKey = keyFile;
    }

    public void setClientPrivateKeyPassword(String privateKeyPassword) {
        this.clientPrivateKeyPassword = privateKeyPassword;
    }

    public void setClientProxy(String clientProxy) {
        this.clientProxy = clientProxy;
    }

    public void setTargetEndpoint(String endpointURL) {
        this.serviceURL = endpointURL;
    }

    protected void initializeAxisProperties() {
        DefaultConfigurator socketFactoryConfigurator = new DefaultConfigurator();
        if (this.clientProxy != null) {
            socketFactoryConfigurator.setProxyFile(this.clientProxy);
        } else {
            if (this.clientCertificate != null) {
                socketFactoryConfigurator.setCertFile(this.clientCertificate);
            }
            if (this.clientPrivateKey != null) {
                socketFactoryConfigurator.setKeyFile(this.clientPrivateKey);
            }
            if (this.clientPrivateKeyPassword != null) {
                socketFactoryConfigurator.setKeyPassword(this.clientPrivateKeyPassword);
            }
        }
        CANLAxis1SocketFactory.setConfigurator(socketFactoryConfigurator);
        String socketFactoryClass = CANLAxis1SocketFactory.class.getName();
        AxisProperties.setProperty((String)AXIS_SOCKET_FACTORY_PROPERTY, (String)socketFactoryClass);
    }
}

