/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicySetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorePolicySetOperation
extends BasePAPOperation<String> {
    String alias;
    String idPrefix;
    PolicySetType policySet;

    private StorePolicySetOperation(String alias, String idPrefix, PolicySetType policySet) {
        this.alias = alias;
        this.idPrefix = idPrefix;
        this.policySet = policySet;
    }

    public static StorePolicySetOperation instance(String alias, String idPrefix, PolicySetType policySet) {
        return new StorePolicySetOperation(alias, idPrefix, policySet);
    }

    @Override
    protected String doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        String policySetId = WizardUtils.generateId(this.idPrefix);
        this.policySet.setPolicySetId(policySetId);
        papContainer.storePolicySet(this.policySet);
        TypeStringUtils.releaseUnneededMemory(this.policySet);
        return policySetId;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

