/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovePolicyOperation
extends BasePAPOperation<Boolean> {
    String alias;
    String policyId;

    private RemovePolicyOperation(String alias, String policyId) {
        this.alias = alias;
        this.policyId = policyId;
    }

    public static RemovePolicyOperation instance(String alias, String policyId) {
        return new RemovePolicyOperation(alias, policyId);
    }

    @Override
    protected Boolean doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        try {
            papContainer.deletePolicy(this.policyId);
        }
        catch (NotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

