/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.utils.PolicyHelper;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.RuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveOperation
extends BasePAPOperation<Object> {
    private static final Logger log = LoggerFactory.getLogger(MoveOperation.class);
    String alias;
    String id;
    String pivotId;
    boolean moveAfter;

    protected MoveOperation(String alias, String id, String pivotId, boolean moveAfter) {
        this.alias = alias;
        this.id = id;
        this.pivotId = pivotId;
        this.moveAfter = moveAfter;
    }

    public static MoveOperation instance(String alias, String id, String pivotId, boolean moveAfter) {
        return new MoveOperation(alias, id, pivotId, moveAfter);
    }

    @Override
    protected Object doExecute() {
        Pap pap;
        if (this.id == null || this.pivotId == null) {
            return null;
        }
        if (this.id.equals(this.pivotId)) {
            return null;
        }
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote pap");
        }
        PapContainer papContainer = new PapContainer(pap);
        if (papContainer.hasPolicySet(this.id)) {
            this.movePolicySet(papContainer);
        } else if (papContainer.hasPolicy(this.id)) {
            this.movePolicy(papContainer);
        } else {
            this.moveRule(papContainer);
        }
        return null;
    }

    private void movePolicySet(PapContainer papContainer) {
        PolicySetType rootPAPPolicySet = papContainer.getRootPolicySet();
        if (!PolicySetHelper.hasPolicySetReferenceId(rootPAPPolicySet, this.pivotId)) {
            throw new RepositoryException("Id not found or not a resource-id: " + this.pivotId);
        }
        if (!PolicySetHelper.deletePolicySetReference(rootPAPPolicySet, this.id)) {
            throw new RepositoryException(String.format("Id \"%s\" not found into resource \"%s\"", this.id, rootPAPPolicySet.getPolicySetId()));
        }
        int pivotIndex = PolicySetHelper.getPolicySetIdReferenceIndex(rootPAPPolicySet, this.pivotId);
        if (this.moveAfter) {
            ++pivotIndex;
        }
        log.debug("New position for PolicySet is: " + pivotIndex);
        PolicySetHelper.addPolicySetReference(rootPAPPolicySet, pivotIndex, this.id);
        String version = rootPAPPolicySet.getVersion();
        PolicySetWizard.increaseVersion(rootPAPPolicySet);
        papContainer.updatePolicySet(version, rootPAPPolicySet);
    }

    private void movePolicy(PapContainer papContainer) {
        PolicySetType targetPolicySet = null;
        for (PolicySetType policySet : papContainer.getAllPolicySets()) {
            PolicySetType tempPolicySet = policySet;
            if (!PolicySetHelper.hasPolicyReferenceId(tempPolicySet, this.pivotId)) continue;
            targetPolicySet = tempPolicySet;
            break;
        }
        if (targetPolicySet == null) {
            throw new RepositoryException("Id not found or not an action-id: " + this.pivotId);
        }
        if (!PolicySetHelper.deletePolicyReference(targetPolicySet, this.id)) {
            throw new RepositoryException(String.format("Id \"%s\" not found into resource \"%s\"", this.id, targetPolicySet.getPolicySetId()));
        }
        int pivotIndex = PolicySetHelper.getPolicyIdReferenceIndex(targetPolicySet, this.pivotId);
        if (this.moveAfter) {
            ++pivotIndex;
        }
        log.debug("New position for Policy is: " + pivotIndex);
        PolicySetHelper.addPolicyReference(targetPolicySet, pivotIndex, this.id);
        String version = targetPolicySet.getVersion();
        PolicySetWizard.increaseVersion(targetPolicySet);
        papContainer.updatePolicySet(version, targetPolicySet);
    }

    private void moveRule(PapContainer papContainer) {
        PolicyType targetPolicy = null;
        for (PolicyType policy : papContainer.getAllPolicies()) {
            if (!PolicyHelper.hasRuleWithId(policy, this.pivotId)) continue;
            targetPolicy = policy;
            break;
        }
        if (targetPolicy == null) {
            throw new RepositoryException("Id not found or not a rule-id: " + this.pivotId);
        }
        RuleType rule = PolicyHelper.removeRule(targetPolicy, this.id);
        if (rule == null) {
            throw new RepositoryException(String.format("Id \"%s\" not found into action \"%s\"", this.id, targetPolicy.getPolicyId()));
        }
        int pivotIndex = PolicyHelper.indexOfRule(targetPolicy, this.pivotId);
        if (this.moveAfter) {
            ++pivotIndex;
        }
        PolicyHelper.addRule(targetPolicy, pivotIndex, rule);
        String version = targetPolicy.getVersion();
        PolicyWizard.increaseVersion(targetPolicy);
        papContainer.updatePolicy(version, targetPolicy);
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

