/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicySetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPolicySetOperation
extends BasePAPOperation<String> {
    String alias;
    int index;
    PolicySetType policySet;

    protected AddPolicySetOperation(String alias, int index, PolicySetType policySet) {
        this.alias = alias;
        this.index = index;
        this.policySet = policySet;
    }

    public static AddPolicySetOperation instance(String alias, int index, PolicySetType policySet) {
        return new AddPolicySetOperation(alias, index, policySet);
    }

    @Override
    protected String doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        String policySetId = WizardUtils.generateId(null);
        this.policySet.setPolicySetId(policySetId);
        papContainer.addPolicySet(this.index, this.policySet);
        TypeStringUtils.releaseUnneededMemory(this.policySet);
        this.log.info(String.format("Added policy set (policyId=\"%s\")", policySetId));
        return policySetId;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

