/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPolicyOperation
extends BasePAPOperation<String> {
    String alias;
    int index;
    PolicyType policy;
    String policyIdPrefix;
    String policySetId;

    protected AddPolicyOperation(String alias, int index, String policySetId, String policyIdPrefix, PolicyType policy) {
        this.alias = alias;
        this.index = index;
        this.policySetId = policySetId;
        this.policyIdPrefix = policyIdPrefix;
        this.policy = policy;
    }

    public static AddPolicyOperation instance(String alias, int index, String policySetId, String policyIdPrefix, PolicyType policy) {
        return new AddPolicyOperation(alias, index, policySetId, policyIdPrefix, policy);
    }

    @Override
    protected String doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        if (!papContainer.hasPolicySet(this.policySetId)) {
            this.log.warn(String.format("Policy not added because PolicySetId \"%s\" does not exists.", this.policySetId));
            return null;
        }
        String policyId = WizardUtils.generateId(this.policyIdPrefix);
        this.policy.setPolicyId(policyId);
        papContainer.addPolicy(this.index, this.policySetId, this.policy);
        TypeStringUtils.releaseUnneededMemory(this.policy);
        this.log.info(String.format("Added policy (policyId=\"%s\")", policyId));
        return policyId;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

