/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.papmanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.papmanagement.PapManagerException;
import org.glite.authz.pap.repository.exceptions.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePapOperation
extends BasePAPOperation<Boolean> {
    Pap pap;

    protected UpdatePapOperation(Pap pap) {
        this.pap = pap;
    }

    public static UpdatePapOperation instance(Pap pap) {
        return new UpdatePapOperation(pap);
    }

    @Override
    protected Boolean doExecute() {
        if ("default".equals(this.pap.getAlias())) {
            throw new PapManagerException("Forbidden operation: the default PAP is read-only.");
        }
        try {
            PapManager.getInstance().updatePap(this.pap);
        }
        catch (NotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.CONFIGURATION_READ, PAPPermission.PermissionFlags.CONFIGURATION_WRITE));
    }
}

