/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.papmanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.exceptions.AlreadyExistsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPapOperation
extends BasePAPOperation<Boolean> {
    Pap pap;

    protected AddPapOperation(Pap pap) {
        this.pap = pap;
    }

    public static AddPapOperation instance(Pap pap) {
        return new AddPapOperation(pap);
    }

    @Override
    protected Boolean doExecute() {
        this.log.info("Adding PAP: " + this.pap);
        try {
            PapManager.getInstance().addPap(this.pap);
        }
        catch (AlreadyExistsException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.CONFIGURATION_WRITE));
    }
}

