/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.highlevelpolicymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.HighLevelPolicyManagementServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeOperation
extends BasePAPOperation<Object> {
    private String alias;
    private boolean purgeUnreferencedPolicies;
    private boolean purgeEmptyPolicies;
    private boolean purgeUnreferencedPolicySets;
    private boolean purgeEmptyPolicySets;

    protected PurgeOperation(String alias, boolean purgeUnreferencedPolicies, boolean purgeEmptyPolicies, boolean purgeUnreferencedPolicySets, boolean purgeEmptyPolicySets) {
        this.alias = alias;
        this.purgeUnreferencedPolicies = purgeUnreferencedPolicies;
        this.purgeEmptyPolicies = purgeEmptyPolicies;
        this.purgeUnreferencedPolicySets = purgeUnreferencedPolicySets;
        this.purgeEmptyPolicySets = purgeEmptyPolicySets;
    }

    public static PurgeOperation instance(String alias, boolean purgeUnreferencedPolicies, boolean purgeEmptyPolicies, boolean purgeUnreferencedPolicySets, boolean purgeEmptyPolicySets) {
        return new PurgeOperation(alias, purgeUnreferencedPolicies, purgeEmptyPolicies, purgeUnreferencedPolicySets, purgeEmptyPolicySets);
    }

    @Override
    protected Object doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new HighLevelPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        if (this.purgeUnreferencedPolicies) {
            papContainer.purgeUnreferencesPolicies();
        }
        if (this.purgeEmptyPolicies) {
            papContainer.purgePoliciesWithNoRules();
        }
        if (this.purgeUnreferencedPolicySets) {
            papContainer.purgeUnreferencedPolicySets();
        }
        if (this.purgeEmptyPolicySets) {
            papContainer.purgePolicySetWithNoPolicies();
        }
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE, PAPPermission.PermissionFlags.POLICY_READ_LOCAL));
    }
}

