/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.highlevelpolicymanagement;

import java.util.List;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.common.xacml.wizard.TargetWizard;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BanOperation
extends BasePAPOperation<String> {
    private String alias;
    private AttributeWizard actionAttributeWizard;
    private AttributeWizard banAttributeWizard;
    private boolean isPublic;
    private AttributeWizard resourceAttributeWizard;

    protected BanOperation(String alias, AttributeWizard banAttributeWizard, AttributeWizard resourceAttributeWizard, AttributeWizard actionAttributeWizard, boolean isPublic) {
        this.alias = alias;
        this.banAttributeWizard = banAttributeWizard;
        this.resourceAttributeWizard = resourceAttributeWizard;
        this.actionAttributeWizard = actionAttributeWizard;
        this.isPublic = isPublic;
    }

    public static BanOperation instance(String alias, AttributeWizard banAttributeWizard, AttributeWizard resourceAttributeWizard, AttributeWizard actionAttributeWizard, boolean isPublic) {
        return new BanOperation(alias, banAttributeWizard, resourceAttributeWizard, actionAttributeWizard, isPublic);
    }

    @Override
    protected String doExecute() {
        String oldVersion;
        PolicyWizard targetPolicyWizard;
        Pap pap;
        boolean policySetNeedToBeSaved = true;
        boolean updateOperationForPolicySet = false;
        boolean updateOperationForPolicy = false;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        PolicySetType targetPolicySet = this.getTargetPolicySet(papContainer);
        if (targetPolicySet == null) {
            targetPolicySet = new PolicySetWizard(this.resourceAttributeWizard).getXACML();
        } else {
            updateOperationForPolicySet = true;
        }
        String policyId = null;
        PolicyType candidatePolicy = this.getTargetPolicy(papContainer, targetPolicySet);
        if (candidatePolicy == null) {
            targetPolicyWizard = new PolicyWizard(this.actionAttributeWizard);
            targetPolicyWizard.setPrivate(!this.isPublic);
            policyId = targetPolicyWizard.getPolicyId();
            PolicySetHelper.addPolicyReference(targetPolicySet, 0, policyId);
        } else {
            targetPolicyWizard = new PolicyWizard(candidatePolicy);
            if (targetPolicyWizard.denyRuleForAttributeExists(this.banAttributeWizard)) {
                return null;
            }
            policyId = candidatePolicy.getPolicyId();
            updateOperationForPolicy = true;
            policySetNeedToBeSaved = false;
        }
        targetPolicyWizard.addRule(0, this.banAttributeWizard, EffectType.Deny);
        if (policySetNeedToBeSaved) {
            if (updateOperationForPolicySet) {
                oldVersion = targetPolicySet.getVersion();
                PolicySetWizard.increaseVersion(targetPolicySet);
                papContainer.updatePolicySet(oldVersion, targetPolicySet);
            } else {
                papContainer.addPolicySet(0, targetPolicySet);
            }
        } else {
            TypeStringUtils.releaseUnneededMemory(targetPolicySet);
        }
        if (updateOperationForPolicy) {
            oldVersion = targetPolicyWizard.getVersionString();
            targetPolicyWizard.increaseVersion();
            papContainer.updatePolicy(oldVersion, targetPolicyWizard.getXACML());
        } else {
            papContainer.storePolicy(targetPolicyWizard.getXACML());
        }
        targetPolicyWizard.releaseChildrenDOM();
        targetPolicyWizard.releaseDOM();
        return policyId;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }

    private PolicyType getTargetPolicy(PapContainer papContainer, PolicySetType policySet) {
        List<String> policyIdList = PolicySetHelper.getPolicyIdReferencesValues(policySet);
        if (policyIdList.size() == 0) {
            return null;
        }
        PolicyType candidatePolicy = papContainer.getPolicy(policyIdList.get(0));
        PolicyType policy = null;
        TargetWizard policyTargetWizard = new TargetWizard(this.actionAttributeWizard);
        if (policyTargetWizard.isEquivalent(candidatePolicy.getTarget()) && PolicyWizard.isPublic((policy = candidatePolicy).getPolicyId()) != this.isPublic) {
            return null;
        }
        return policy;
    }

    private PolicySetType getTargetPolicySet(PapContainer papContainer) {
        PolicySetType targetPolicySet = null;
        TargetWizard policySetTargetWizard = new TargetWizard(this.resourceAttributeWizard);
        PolicySetType papRootPolicySet = papContainer.getRootPolicySet();
        List<String> policySetIdList = PolicySetHelper.getPolicySetIdReferencesValues(papRootPolicySet);
        TypeStringUtils.releaseUnneededMemory(papRootPolicySet);
        if (policySetIdList.size() == 0) {
            return null;
        }
        PolicySetType candidatePolicySet = papContainer.getPolicySet(policySetIdList.get(0));
        if (policySetTargetWizard.isEquivalent(candidatePolicySet.getTarget())) {
            targetPolicySet = candidatePolicySet;
        }
        return targetPolicySet;
    }
}

