/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.authzmanagement;

import java.util.HashMap;
import java.util.Map;
import org.glite.authz.pap.authz.AuthorizationEngine;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPAdmin;
import org.glite.authz.pap.authz.PAPContext;
import org.glite.authz.pap.authz.PAPPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetACLOperation
extends BasePAPOperation<Object> {
    PAPContext context = AuthorizationEngine.instance().getGlobalContext();
    Map<PAPAdmin, PAPPermission> permissions;

    private SetACLOperation(String context, Map<PAPAdmin, PAPPermission> permissions) {
        this.permissions = permissions;
    }

    public static SetACLOperation instance(String context, Map<PAPAdmin, PAPPermission> permissions) {
        return new SetACLOperation(context, permissions);
    }

    protected Map<PAPAdmin, PAPPermission> clonePermissions(Map<PAPAdmin, PAPPermission> toBeCloned) {
        HashMap clonedMap = (HashMap)((HashMap)toBeCloned).clone();
        return clonedMap;
    }

    @Override
    protected Object doExecute() {
        Map<PAPAdmin, PAPPermission> oldPerms = this.clonePermissions(this.context.getAcl().getPermissions());
        try {
            this.context.getAcl().getPermissions().clear();
            this.context.getAcl().setPermissions(this.permissions);
        }
        catch (Throwable t) {
            this.log.error("Error setting ACL! " + t.getMessage(), t);
            this.log.error("Restoring previous permissions...");
            this.context.getAcl().setPermissions(oldPerms);
        }
        oldPerms.clear();
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.CONFIGURATION_READ, PAPPermission.PermissionFlags.CONFIGURATION_WRITE));
    }
}

