/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import java.io.File;
import java.security.cert.X509Certificate;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.ac.ValidationResultListener;
import org.italiangrid.voms.error.VOMSValidationErrorMessage;
import org.italiangrid.voms.store.LSCInfo;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSListener
implements VOMSTrustStoreStatusListener,
ValidationResultListener {
    public static final Logger logger = LoggerFactory.getLogger(VOMSListener.class);

    public void notifyCertficateLookupEvent(String dir) {
        logger.debug("Looking for VOMS trusted certificates in {}", (Object)dir);
    }

    public void notifyLSCLookupEvent(String dir) {
        logger.debug("Looking for VOMS LSC files in {}", (Object)dir);
    }

    public void notifyCertificateLoadEvent(X509Certificate cert, File f) {
        logger.debug("VOMS AA certificate loaded from {}", (Object)f.getAbsolutePath());
        logger.debug("Certificate info: {}", (Object)CertificateUtils.format((X509Certificate)cert, (FormatMode)FormatMode.MEDIUM_ONE_LINE));
    }

    public void notifyLSCLoadEvent(LSCInfo lsc, File f) {
        logger.debug("VOMS LSC file loaded from {}", (Object)f.getAbsolutePath());
        logger.debug("LSC info: {}", (Object)lsc);
    }

    public void notifyValidationResult(VOMSValidationResult result) {
        if (!result.isValid()) {
            logger.error("VOMS AC validation for VO {} failed for the following reasons:", (Object)result.getAttributes().getVO());
            for (VOMSValidationErrorMessage m : result.getValidationErrors()) {
                logger.error("{}", (Object)m.getMessage());
            }
        } else {
            logger.debug("VOMS AC validation for VO %s succeded.\n", (Object)result.getAttributes().getVO());
        }
    }
}

