/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.lang.StringUtils;
import org.glite.authz.pap.authz.exceptions.PAPAuthzException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAPPermission {
    private EnumSet<PermissionFlags> permissions = EnumSet.noneOf(PermissionFlags.class);

    protected PAPPermission() {
    }

    public static PAPPermission fromStringArray(String[] perms) {
        PAPPermission perm = new PAPPermission();
        for (String s : perms) {
            if ("ALL".equals(s)) {
                perm.permissions.addAll(EnumSet.allOf(PermissionFlags.class));
                break;
            }
            try {
                PermissionFlags newPerm = PermissionFlags.valueOf(s.trim());
                perm.permissions.add(newPerm);
            }
            catch (IllegalArgumentException e) {
                throw new PAPAuthzException("Unknown permission passed as argument! '" + s + "'.", e);
            }
        }
        return perm;
    }

    public static PAPPermission fromString(String s) {
        String[] perms = StringUtils.split((String)s, (String)"|");
        if (perms.length == 1 && perms[0].equals("")) {
            PAPPermission perm = new PAPPermission();
            return perm;
        }
        return PAPPermission.fromStringArray(perms);
    }

    public boolean satisfies(PAPPermission other) {
        return this.permissions.containsAll(other.permissions);
    }

    public String toString() {
        if (this.permissions.containsAll(EnumSet.allOf(PermissionFlags.class))) {
            return "ALL";
        }
        return StringUtils.join(this.permissions.iterator(), (String)"|");
    }

    public boolean has(PermissionFlags perm) {
        return this.permissions.contains((Object)perm);
    }

    public boolean hasAll(EnumSet<PermissionFlags> perms) {
        return this.permissions.containsAll(perms);
    }

    public String[] toStringArray() {
        String[] perms = new String[this.permissions.size()];
        int i = 0;
        for (PermissionFlags p : this.permissions) {
            perms[i++] = p.name();
        }
        return perms;
    }

    public static PAPPermission getAllPermission() {
        return PAPPermission.fromString("ALL");
    }

    public static PAPPermission getEmptyPermission() {
        return new PAPPermission();
    }

    public boolean add(PAPPermission o) {
        if (o == null) {
            return false;
        }
        return this.addAll(o.permissions);
    }

    protected boolean addAll(Collection<? extends PermissionFlags> c) {
        return this.permissions.addAll(c);
    }

    public static PAPPermission of(PermissionFlags p) {
        PAPPermission papPerm = new PAPPermission();
        papPerm.permissions.add(p);
        return papPerm;
    }

    public static PAPPermission of(PermissionFlags first, PermissionFlags second) {
        PAPPermission papPerm = new PAPPermission();
        papPerm.permissions.add(first);
        papPerm.permissions.add(second);
        return papPerm;
    }

    public static PAPPermission of(PermissionFlags first, PermissionFlags ... flags) {
        PAPPermission papPerm = new PAPPermission();
        papPerm.permissions.add(first);
        for (PermissionFlags p : flags) {
            papPerm.permissions.add(p);
        }
        return papPerm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PermissionFlags {
        POLICY_READ_LOCAL,
        POLICY_READ_REMOTE,
        POLICY_WRITE,
        CONFIGURATION_READ,
        CONFIGURATION_WRITE;

    }
}

