/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import org.glite.authz.pap.authz.VOMSFQAN;
import org.glite.authz.pap.authz.X509Principal;

public class PAPAdminFactory {
    public static final String ANY_AUTHENTICATED_USER_DN = "/O=PAP/OU=Internal/CN=Any authenticated user";
    public static final X509Principal AnyAuthenticatedUserAdmin = PAPAdminFactory.getDn("/O=PAP/OU=Internal/CN=Any authenticated user");

    public static VOMSFQAN getFQAN(String fqan) {
        fqan = fqan.replaceAll("\\/Role=NULL", "");
        fqan = fqan.replaceAll("\\/Capability=NULL", "");
        return new VOMSFQAN(fqan);
    }

    public static X509Principal getDn(String dn) {
        if (dn.startsWith("/")) {
            return new X509Principal(dn);
        }
        return new X509Principal(OpensslNameUtils.convertFromRfc2253((String)dn, (boolean)false));
    }

    public static X509Principal getAnyAuthenticatedUserAdmin() {
        return AnyAuthenticatedUserAdmin;
    }
}

