/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletRequest;
import org.glite.authz.pap.authz.exceptions.PAPAuthzException;
import org.italiangrid.utils.voms.SecurityContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSecurityContext {
    public static final String SECURITY_CONTEXT_REMOTE_ADDRESS = "org.glite.authz.pap.remote_address";
    static Logger logger = LoggerFactory.getLogger(InitSecurityContext.class);

    public static void setContextFromRequest(ServletRequest request) {
        SecurityContextImpl sc = new SecurityContextImpl();
        SecurityContextImpl.setCurrentContext((SecurityContextImpl)sc);
        String remoteAddress = request.getRemoteAddr();
        sc.setRemoteAddr(remoteAddress);
        X509Certificate[] certChain = null;
        try {
            certChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        catch (Exception e) {
            logger.error("Exception during certificate chain retrieval: " + e);
            throw new PAPAuthzException("No certificate found in request!", e);
        }
        if (certChain == null) {
            throw new PAPAuthzException("No certificate found in request!");
        }
        sc.setClientCertChain(certChain);
        String subject = X500NameUtils.getReadableForm((X500Principal)sc.getClientX500Principal());
        String issuer = X500NameUtils.getReadableForm((X500Principal)sc.getIssuerX500Principal());
        BigInteger sn = sc.getClientCert().getSerialNumber();
        String serialNumber = sn == null ? "NULL" : sn.toString();
        logger.info("Connection from \"" + remoteAddress + "\" by \"" + subject + "\" (issued by \"" + issuer + "\", " + "serial " + serialNumber + ")");
    }
}

