/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.glite.authz.pap.authz.ACL;
import org.glite.authz.pap.authz.PAPAdmin;
import org.glite.authz.pap.authz.PAPAdminFactory;
import org.glite.authz.pap.authz.PAPContext;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.authz.PAPPermissionList;
import org.glite.authz.pap.authz.VOMSFQAN;
import org.glite.authz.pap.authz.VOMSListener;
import org.glite.authz.pap.authz.X509Principal;
import org.glite.authz.pap.authz.exceptions.PAPAuthzException;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.common.exceptions.NullArgumentException;
import org.italiangrid.utils.voms.SecurityContextImpl;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.ac.ValidationResultListener;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.italiangrid.voms.store.VOMSTrustStores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentAdmin {
    static Logger log = LoggerFactory.getLogger(CurrentAdmin.class);
    static VOMSACValidator validator = null;
    private PAPAdmin papAdmin;
    private VOMSFQAN[] fqans;

    protected CurrentAdmin(PAPAdmin admin) {
        this.papAdmin = admin;
    }

    protected synchronized VOMSACValidator getValidator() {
        if (validator == null) {
            VOMSListener l = new VOMSListener();
            VOMSTrustStore ts = VOMSTrustStores.newTrustStore(Arrays.asList("/etc/grid-security/vomsdir"), (long)TimeUnit.MINUTES.toMillis(30L), (VOMSTrustStoreStatusListener)l);
            X509CertChainValidatorExt certChainValidator = PAPConfiguration.instance().getCertchainValidator();
            validator = VOMSValidators.newValidator((VOMSTrustStore)ts, (X509CertChainValidatorExt)certChainValidator, (ValidationResultListener)l);
        }
        return validator;
    }

    protected synchronized void getFQANsFromSecurityContext() {
        log.debug("Fectching FQANs out of the security context");
        SecurityContextImpl ctxt = SecurityContextImpl.getCurrentContext();
        try {
            List attrs = validator.validate(ctxt.getClientCertChain());
            ArrayList<VOMSFQAN> myFQANs = new ArrayList<VOMSFQAN>();
            for (VOMSAttribute voAttr : attrs) {
                List fqanAttrs = voAttr.getFQANs();
                if (fqanAttrs.size() <= 0) continue;
                for (String f : fqanAttrs) {
                    myFQANs.add(PAPAdminFactory.getFQAN(f));
                }
                if (!log.isDebugEnabled()) continue;
                String fqansString = StringUtils.join(myFQANs, (String)",");
                log.debug("X509Principal: '{}' has valid fqans: '{}'", (Object)this.papAdmin, (Object)fqansString);
            }
            if (myFQANs.size() > 0) {
                this.fqans = myFQANs.toArray(new VOMSFQAN[0]);
            } else {
                log.debug("No VOMS AC found in client certificate chain");
            }
        }
        catch (Throwable t) {
            log.warn("Error validating voms attributes out of the cert chain:", (Object)t.getMessage());
        }
    }

    public static CurrentAdmin instance() {
        SecurityContextImpl theContext = SecurityContextImpl.getCurrentContext();
        String rfcReadableString = X500NameUtils.getReadableForm((X500Principal)theContext.getClientX500Principal());
        String adminDN = OpensslNameUtils.convertFromRfc2253((String)rfcReadableString, (boolean)false);
        X509Principal papAdmin = PAPAdminFactory.getDn(adminDN);
        if (papAdmin == null) {
            papAdmin = PAPAdminFactory.getAnyAuthenticatedUserAdmin();
        }
        return new CurrentAdmin(papAdmin);
    }

    private boolean contextHasFQANPermissions(PAPContext context) {
        if (context == null) {
            throw new NullArgumentException("Please provide a value for the 'context' argument! null is not a valid value in this context.");
        }
        ACL acl = context.getAcl();
        if (acl == null) {
            throw new PAPAuthzException("FATAL ERROR: No ACL defined for context '" + context.getName() + "'!");
        }
        for (PAPAdmin a : acl.getPermissions().keySet()) {
            if (!(a instanceof VOMSFQAN)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissions(PAPContext context, PAPPermission requiredPerms) {
        PAPPermissionList currentAdminPermList = PAPPermissionList.instance();
        PAPPermission adminPerms = context.getAcl().getPermissions().get(this.papAdmin);
        PAPPermission anyUserPerms = context.getAcl().getAnyAuthenticatedUserPermissions();
        currentAdminPermList.addPermission(adminPerms);
        currentAdminPermList.addPermission(anyUserPerms);
        if (this.contextHasFQANPermissions(context)) {
            log.debug("FQAN permissions defined for context '" + context + "'");
            this.getFQANsFromSecurityContext();
            if (this.fqans != null) {
                for (VOMSFQAN fqan : this.fqans) {
                    PAPPermission fqanPerms = context.getAcl().getPermissions().get(fqan);
                    if (fqanPerms == null) continue;
                    currentAdminPermList.addPermission(fqanPerms);
                    log.debug("Adding permissions '{}' for fqan '{}'", (Object)fqanPerms, (Object)fqan);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Checking perms '%s' for admin '%s' in context '%s'", requiredPerms, this.papAdmin, context));
            log.debug(String.format("CurrrentAdminPerms: '%s'", currentAdminPermList));
        }
        return currentAdminPermList.satisfies(requiredPerms);
    }
}

