/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glite.authz.pap.authz.ACL;
import org.glite.authz.pap.authz.BasePAPAdmin;
import org.glite.authz.pap.authz.PAPAdmin;
import org.glite.authz.pap.authz.PAPAdminFactory;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.authz.VOMSFQAN;
import org.glite.authz.pap.authz.X509Principal;
import org.glite.authz.pap.authz.exceptions.PAPAuthzConfigurationException;
import org.glite.authz.pap.common.exceptions.VOMSSyntaxException;
import org.glite.authz.pap.common.utils.PathNamingScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthzConfigurationParser {
    public static final Logger log = LoggerFactory.getLogger(AuthzConfigurationParser.class);
    public static final String permissionRegex = "^([^:]+):\\s*((\\w\\|?)+)";
    public static final Pattern permissionPattern = Pattern.compile("^([^:]+):\\s*((\\w\\|?)+)");
    public static final String anyUserRegex = "^ANYONE\\s*";
    public static final Pattern anyUserPattern = Pattern.compile("^ANYONE\\s*");
    public static final String dnRegex = "^\"(/[^=]+=.*)\"\\s*";
    public static final String rfc2253DnRegex = "^\"([^\"]+)\"\\s*";
    public static final Pattern dnPattern = Pattern.compile("^\"(/[^=]+=.*)\"\\s*");
    public static final Pattern rfc2253DnPattern = Pattern.compile("^\"([^\"]+)\"\\s*");
    public static final String emptyLineRegex = "\\s*$";
    public static final Pattern emptyLinePattern = Pattern.compile("\\s*$");
    public static final String commentRegex = "^[#;].*$";
    public static final Pattern commentPattern = Pattern.compile("^[#;].*$");
    public static final String stanzaRegex = "^(\\[\\w+\\])\\s*$";
    public static final Pattern stanzaPattern = Pattern.compile("^(\\[\\w+\\])\\s*$");
    EnumMap<Sections, String> sectionNames = new EnumMap(Sections.class);
    private ACL globalContextACL;
    private ParserStates state = ParserStates.UNDEFINED;
    private int lineCounter = 0;

    private AuthzConfigurationParser() {
        this.sectionNames.put(Sections.DN, "[dn]");
        this.sectionNames.put(Sections.FQAN, "[fqan]");
        this.globalContextACL = new ACL();
    }

    protected void parseLine(String line) {
        if (line.length() == 0) {
            return;
        }
        Matcher stanzaMatcher = stanzaPattern.matcher(line);
        Matcher commentMatcher = commentPattern.matcher(line);
        Matcher emptyLineMatcher = emptyLinePattern.matcher(line);
        Matcher permissionMatcher = permissionPattern.matcher(line);
        if (commentMatcher.matches()) {
            return;
        }
        if (emptyLineMatcher.matches()) {
            return;
        }
        if (stanzaMatcher.matches()) {
            String stanzaName = stanzaMatcher.group();
            if (!this.sectionNames.values().contains(stanzaName)) {
                throw new PAPAuthzConfigurationException("Stanza '" + stanzaName + "' is not supported!");
            }
            if ("[dn]".equals(stanzaName)) {
                this.state = ParserStates.DNs;
            } else if ("[fqan]".equals(stanzaName)) {
                this.state = ParserStates.FQANs;
            }
            return;
        }
        if (permissionMatcher.matches()) {
            String principalName = permissionMatcher.group(1);
            String permissions = permissionMatcher.group(2);
            PAPPermission perm = PAPPermission.fromString(permissions);
            Matcher dnMatcher = null;
            dnMatcher = principalName.startsWith("\"/") ? dnPattern.matcher(principalName) : rfc2253DnPattern.matcher(principalName);
            Matcher anyUserMatcher = anyUserPattern.matcher(principalName);
            if (anyUserMatcher.matches()) {
                if (!this.state.equals((Object)ParserStates.DNs)) {
                    throw new PAPAuthzConfigurationException("Found an X509 ANYONE declaration outside of the [dn] stanza!");
                }
                X509Principal admin = PAPAdminFactory.getAnyAuthenticatedUserAdmin();
                this.globalContextACL.setPermissions(admin, perm);
            } else if (dnMatcher.matches()) {
                if (!this.state.equals((Object)ParserStates.DNs)) {
                    throw new PAPAuthzConfigurationException("Found an X509 DN outside of the [dn] stanza!");
                }
                String dn = dnMatcher.group(1);
                X509Principal admin = PAPAdminFactory.getDn(dn);
                this.globalContextACL.setPermissions(admin, perm);
            } else {
                try {
                    principalName = principalName.trim();
                    PathNamingScheme.checkSyntax(principalName);
                    if (!this.state.equals((Object)ParserStates.FQANs)) {
                        throw new PAPAuthzConfigurationException("Found a VOMS FQAN outside the [fqan] stanza!");
                    }
                    VOMSFQAN admin = PAPAdminFactory.getFQAN(principalName);
                    this.globalContextACL.setPermissions(admin, perm);
                }
                catch (VOMSSyntaxException e) {
                    throw new PAPAuthzConfigurationException("Unsupported principal name: '" + principalName + "'. Very probably there is a syntax error in the dn or fqan that was being parsed, check the syntax" + " of your configuration file.");
                }
            }
        } else {
            throw new PAPAuthzConfigurationException("Syntax error at line " + this.lineCounter + ": '" + line + "' does not match the PRINCIPAL : PERMISSION format!");
        }
    }

    public ACL parse(File f) {
        try {
            return this.parse(new FileReader(f));
        }
        catch (IOException e) {
            throw new PAPAuthzConfigurationException(e);
        }
    }

    public ACL parse(Reader r) {
        try {
            BufferedReader reader = new BufferedReader(r);
            String line = null;
            this.lineCounter = 0;
            do {
                if ((line = reader.readLine()) == null) continue;
                ++this.lineCounter;
                this.parseLine(line);
            } while (line != null);
            return this.globalContextACL;
        }
        catch (IOException e) {
            throw new PAPAuthzConfigurationException(e);
        }
    }

    public void save(File f, ACL globalContextACL) {
        try {
            BasePAPAdmin p;
            PrintWriter writer = new PrintWriter(f);
            writer.println("[dn]\n\n");
            for (Map.Entry<PAPAdmin, PAPPermission> entry : globalContextACL.getPermissions().entrySet()) {
                if (!(entry.getKey() instanceof X509Principal)) continue;
                p = (X509Principal)entry.getKey();
                String dn = null;
                dn = ((X509Principal)p).equals(PAPAdminFactory.getAnyAuthenticatedUserAdmin()) ? "ANYONE" : "\"" + ((X509Principal)p).getDn() + "\"";
                writer.println(dn + " : " + entry.getValue().toString());
            }
            writer.println("\n\n[fqan]\n\n");
            for (Map.Entry<PAPAdmin, PAPPermission> entry : globalContextACL.getPermissions().entrySet()) {
                if (!(entry.getKey() instanceof VOMSFQAN)) continue;
                p = (VOMSFQAN)entry.getKey();
                writer.println(((VOMSFQAN)p).getFqan() + " : " + entry.getValue().toString());
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            log.error("Error writing authz configuration to file: " + e.getMessage(), (Throwable)e);
            throw new PAPAuthzConfigurationException("Error writing authz configuration to file: " + e.getMessage(), e);
        }
    }

    public ACL getParsedACL() {
        return this.globalContextACL;
    }

    public static AuthzConfigurationParser instance() {
        return new AuthzConfigurationParser();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParserStates {
        DNs,
        FQANs,
        UNDEFINED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Sections {
        DN,
        FQAN;

    }
}

