/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.helpers.AbstractX509Credential;
import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.KeyStoreHelper;
import eu.emi.security.authn.x509.impl.KeystoreCredential;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class KeyAndCertCredential
extends AbstractX509Credential {
    public KeyAndCertCredential(PrivateKey privateKey, X509Certificate[] certificateChain) throws KeyStoreException {
        try {
            this.ks = KeyStoreHelper.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Can't create JKS KeyStore - JDK is misconfgured?", e);
        }
        try {
            this.ks.load(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't init JKS KeyStore - JDK is misconfgured?", e);
        }
        try {
            CertificateHelpers.checkKeysMatching(privateKey, certificateChain[0].getPublicKey());
        }
        catch (InvalidKeyException e) {
            throw new KeyStoreException("Provided private key is not matching the certificate", e);
        }
        this.ks.setKeyEntry("defaultKey", privateKey, KeystoreCredential.KEY_PASSWD, certificateChain);
    }
}

