/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.impl.VOMSRequestFragment;
import org.italiangrid.voms.util.VOMSFQANNamingScheme;
import org.w3c.dom.Document;

public class VOMSRequestFactory {
    private static volatile VOMSRequestFactory instance = null;
    private String orderString;
    private String targetString;
    private long lifetime = 0L;
    protected DocumentBuilder docBuilder;

    public static synchronized VOMSRequestFactory instance() {
        if (instance == null) {
            instance = new VOMSRequestFactory();
        }
        return instance;
    }

    private VOMSRequestFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new VOMSError(e.getMessage());
        }
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public String getOrderString() {
        return this.orderString;
    }

    public void setOrderString(String orderString) {
        this.orderString = orderString;
    }

    public String getTargetString() {
        return this.targetString;
    }

    public void setTargetString(String targetString) {
        this.targetString = targetString;
    }

    private void setOptionsForRequest(VOMSRequestFragment fragment) {
        if (this.orderString != null && this.orderString != "") {
            fragment.buildOrderElement(this.orderString);
        }
        if (this.targetString != null && this.targetString != "") {
            fragment.buildTargetsElement(this.targetString);
        }
        fragment.buildLifetime(this.lifetime);
    }

    private void loadOptions(VOMSACRequest options) {
        this.lifetime = options.getLifetime();
    }

    public Document buildRequest(VOMSACRequest acRequest) {
        this.loadOptions(acRequest);
        Document request = this.docBuilder.newDocument();
        VOMSRequestFragment frag = new VOMSRequestFragment(request);
        if (acRequest.getRequestedFQANs().isEmpty()) {
            if (acRequest.getVoName() == null) {
                throw new VOMSError("No vo name specified for AC retrieval.");
            }
            String voName = acRequest.getVoName();
            if (!voName.startsWith("/")) {
                voName = "/" + voName;
            }
            frag.groupCommand(voName);
            this.setOptionsForRequest(frag);
            request.appendChild(frag.getFragment());
            return request;
        }
        Iterator<String> fqanIter = acRequest.getRequestedFQANs().iterator();
        frag.buildBase64();
        frag.buildVersion();
        while (fqanIter.hasNext()) {
            String FQAN = fqanIter.next();
            if (FQAN.equals("all")) {
                frag.allCommand();
                continue;
            }
            if (VOMSFQANNamingScheme.isGroup(FQAN)) {
                frag.groupCommand(FQAN);
                continue;
            }
            if (VOMSFQANNamingScheme.isRole(FQAN)) {
                frag.roleCommand(VOMSFQANNamingScheme.getRoleName(FQAN));
                continue;
            }
            if (!VOMSFQANNamingScheme.isQualifiedRole(FQAN)) continue;
            frag.mappingCommand(VOMSFQANNamingScheme.getGroupName(FQAN), VOMSFQANNamingScheme.getRoleName(FQAN));
        }
        this.setOptionsForRequest(frag);
        request.appendChild(frag.getFragment());
        return request;
    }
}

