/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.util.ArrayList;
import org.italiangrid.voms.request.VOMSErrorMessage;
import org.italiangrid.voms.request.VOMSResponse;
import org.italiangrid.voms.request.VOMSWarningMessage;
import org.italiangrid.voms.request.impl.GoodACDecodingStrategy;
import org.italiangrid.voms.util.VOMSBase64Decoder;
import org.italiangrid.voms.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LegacyVOMSResponse
implements VOMSResponse {
    private static int ERROR_OFFSET = 1000;
    protected Document xmlResponse;

    public LegacyVOMSResponse(Document res) {
        this.xmlResponse = res;
    }

    public int getVersion() {
        Element versionElement = (Element)this.xmlResponse.getElementsByTagName("version").item(0);
        if (versionElement == null) {
            return 0;
        }
        return Integer.parseInt(versionElement.getFirstChild().getNodeValue());
    }

    public boolean hasErrors() {
        return this.errorMessages() != null;
    }

    public boolean hasWarnings() {
        return this.warningMessages() != null;
    }

    public byte[] getAC() {
        Element acElement = (Element)this.xmlResponse.getElementsByTagName("ac").item(0);
        byte[] ac = VOMSBase64Decoder.decode(acElement.getFirstChild().getNodeValue());
        if (ac == null) {
            ac = new GoodACDecodingStrategy().decode(acElement.getFirstChild().getNodeValue());
        }
        return ac;
    }

    public VOMSErrorMessage[] errorMessages() {
        NodeList nodes = this.xmlResponse.getElementsByTagName("item");
        if (nodes.getLength() == 0) {
            return null;
        }
        ArrayList<VOMSErrorMessage> errorList = new ArrayList<VOMSErrorMessage>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            Element numberElement = (Element)itemElement.getElementsByTagName("number").item(0);
            Element messageElement = (Element)itemElement.getElementsByTagName("message").item(0);
            int number = Integer.parseInt(numberElement.getFirstChild().getNodeValue());
            if (number < ERROR_OFFSET) continue;
            errorList.add(new VOMSErrorMessage(number, messageElement.getFirstChild().getNodeValue()));
        }
        if (errorList.isEmpty()) {
            return null;
        }
        return errorList.toArray(new VOMSErrorMessage[errorList.size()]);
    }

    public VOMSWarningMessage[] warningMessages() {
        NodeList nodes = this.xmlResponse.getElementsByTagName("item");
        if (nodes.getLength() == 0) {
            return null;
        }
        ArrayList<VOMSWarningMessage> warningList = new ArrayList<VOMSWarningMessage>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            Element numberElement = (Element)itemElement.getElementsByTagName("number").item(0);
            Element messageElement = (Element)itemElement.getElementsByTagName("message").item(0);
            int number = Integer.parseInt(numberElement.getFirstChild().getNodeValue());
            if (number >= ERROR_OFFSET) continue;
            warningList.add(new VOMSWarningMessage(number, messageElement.getFirstChild().getNodeValue()));
        }
        if (warningList.isEmpty()) {
            return null;
        }
        return warningList.toArray(new VOMSWarningMessage[warningList.size()]);
    }

    public String getXMLAsString() {
        return XMLUtils.documentAsString(this.xmlResponse);
    }
}

