/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.voms;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.italiangrid.utils.voms.SecurityContext;

public class SecurityContextImpl
implements SecurityContext {
    private X509Certificate clientCert;
    private X509Certificate[] clientCertChain;
    private String clientX500Name;
    private X500Principal clientX500Principal;
    private String issuerX500Name;
    private String clientName;
    private String issuerName;
    private X500Principal issuerX500Principal;
    private String remoteAddr;
    private String sessionId;
    private static ThreadLocal<SecurityContextImpl> theSecurityContext = new ThreadLocal();

    public static SecurityContextImpl getCurrentContext() {
        return theSecurityContext.get();
    }

    public static void setCurrentContext(SecurityContextImpl sc) {
        theSecurityContext.set(sc);
    }

    public static void clearCurrentContext() {
        theSecurityContext.set(null);
    }

    public void setClientCert(X509Certificate clientCert) {
        this.clientCert = clientCert;
        X500Principal subject = clientCert.getSubjectX500Principal();
        this.setClientX500Principal(subject);
        this.setClientX500Name(X500NameUtils.getReadableForm((X500Principal)subject));
        this.setClientName(OpensslNameUtils.convertFromRfc2253((String)this.getClientX500Name(), (boolean)false));
        X500Principal issuer = clientCert.getIssuerX500Principal();
        this.setIssuerX500Principal(issuer);
        this.setIssuerX500Name(X500NameUtils.getReadableForm((X500Principal)issuer));
        this.setIssuerName(OpensslNameUtils.convertFromRfc2253((String)this.getIssuerX500Name(), (boolean)false));
    }

    @Override
    public X509Certificate getClientCert() {
        return this.clientCert;
    }

    public void setClientX500Name(String clientX500Name) {
        this.clientX500Name = clientX500Name;
    }

    @Override
    public String getClientX500Name() {
        return this.clientX500Name;
    }

    public void setClientX500Principal(X500Principal clientX500Principal) {
        this.clientX500Principal = clientX500Principal;
    }

    @Override
    public X500Principal getClientX500Principal() {
        return this.clientX500Principal;
    }

    public void setIssuerX500Name(String issuerName) {
        this.issuerX500Name = issuerName;
    }

    @Override
    public String getIssuerX500Name() {
        return this.issuerX500Name;
    }

    public void setIssuerX500Principal(X500Principal issuerPrincipal) {
        this.issuerX500Principal = issuerPrincipal;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.issuerX500Principal;
    }

    public void setClientCertChain(X509Certificate[] clientCertChain) {
        X509Certificate[] orderedClientCertChain = null;
        try {
            orderedClientCertChain = CertificateHelpers.sortChain(Arrays.asList(clientCertChain));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.clientCertChain = orderedClientCertChain;
        if (ProxyUtils.isProxy((X509Certificate[])clientCertChain)) {
            this.setClientCert(ProxyUtils.getEndUserCertificate((X509Certificate[])clientCertChain));
        } else {
            this.setClientCert(clientCertChain[0]);
        }
    }

    @Override
    public X509Certificate[] getClientCertChain() {
        return this.clientCertChain;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }
}

