/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.italiangrid.utils.https.AbstractAdminCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownCommand
extends AbstractAdminCommand {
    private static final long serialVersionUID = 8098511780458295197L;
    private final Logger log = LoggerFactory.getLogger(ShutdownCommand.class);
    private Thread shutdownThread;

    public ShutdownCommand(final List<Runnable> shutdownTasks) {
        super("shutdown");
        if (shutdownTasks == null || shutdownTasks.isEmpty()) {
            return;
        }
        this.shutdownThread = new Thread(){

            @Override
            public void run() {
                for (Runnable shutdownTask : shutdownTasks) {
                    shutdownTask.run();
                }
            }
        };
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.flushBuffer();
        this.log.info("Service shutting down...");
        if (this.shutdownThread != null) {
            this.shutdownThread.start();
        }
    }
}

