/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.italiangrid.utils.https.JettySSLConnectorConfigurator;
import org.italiangrid.utils.https.SSLOptions;
import org.italiangrid.utils.https.impl.canl.CANLSSLConnectorConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFactory {
    public static final int MAX_REQUEST_QUEUE_SIZE = 50;
    public static final int MAX_CONNECTIONS = 50;
    public static final Logger log = LoggerFactory.getLogger(ServerFactory.class);
    private static final JettySSLConnectorConfigurator configurator = new CANLSSLConnectorConfigurator();

    private static void configureThreadPool(Server s) {
        ServerFactory.configureThreadPool(s, 50, 50);
    }

    private static void configureThreadPool(Server s, int maxRequestSize, int maxConnections) {
        if (maxRequestSize <= 0) {
            maxRequestSize = 50;
        }
        if (maxConnections <= 0) {
            maxConnections = 50;
        }
        ArrayBlockingQueue requestQueue = new ArrayBlockingQueue(maxRequestSize);
        s.setThreadPool((ThreadPool)new ExecutorThreadPool(5, maxConnections, 60L, TimeUnit.SECONDS, requestQueue));
    }

    public static Server newServer(String host, int port) {
        return ServerFactory.newServer(host, port, SSLOptions.DEFAULT_OPTIONS);
    }

    public static Server newServer(String host, int port, SSLOptions options) {
        Server server = new Server();
        server.setSendServerVersion(false);
        server.setSendDateHeader(false);
        ServerFactory.configureThreadPool(server);
        Connector connector = configurator.configureConnector(host, port, options);
        if (connector == null) {
            throw new RuntimeException("Error creating SSL connector.");
        }
        server.setConnectors(new Connector[]{connector});
        return server;
    }

    public static Server newServer(String host, int port, SSLOptions options, X509CertChainValidatorExt validator, int maxConnections, int maxRequestQueueSize) {
        Server server = new Server();
        server.setSendServerVersion(false);
        server.setSendDateHeader(false);
        ServerFactory.configureThreadPool(server, maxConnections, maxRequestQueueSize);
        CANLSSLConnectorConfigurator configurator = new CANLSSLConnectorConfigurator(validator);
        Connector connector = configurator.configureConnector(host, port, options);
        if (connector == null) {
            throw new RuntimeException("Error creating SSL connector.");
        }
        server.setConnectors(new Connector[]{connector});
        return server;
    }
}

