/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https;

import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.italiangrid.utils.collections.LazyList;
import org.italiangrid.utils.collections.Strings;
import org.italiangrid.utils.https.AbstractAdminCommand;
import org.italiangrid.utils.https.JettyRunThread;
import org.italiangrid.utils.https.JettyShutdownTask;
import org.italiangrid.utils.https.PasswordProtectFilter;
import org.italiangrid.utils.https.ShutdownCommand;

public class JettyAdminService {
    private Server adminService;
    private String adminHost;
    private int adminPort;
    private String adminPassword;
    private List<AbstractAdminCommand> adminCommands;
    private List<Runnable> shutdownTasks;

    public JettyAdminService(String hostname, int port, String password) {
        this.adminHost = Strings.safeTrimOrNullString(hostname);
        if (this.adminHost == null) {
            throw new IllegalArgumentException("Admin service hostname may not be null");
        }
        this.adminPort = port;
        if (this.adminPort < 1) {
            throw new IllegalArgumentException("Admin port must be greater than 0");
        }
        if (this.adminPort > 65535) {
            throw new IllegalArgumentException("Admin port must be less than 65536");
        }
        this.adminPassword = Strings.safeTrimOrNullString(password);
        this.adminService = this.buildAdminService();
        this.adminCommands = new LazyList<AbstractAdminCommand>();
        this.shutdownTasks = new LazyList<Runnable>();
    }

    public void registerAdminCommand(AbstractAdminCommand command) {
        if (command == null) {
            return;
        }
        if (this.adminService.isRunning()) {
            throw new IllegalStateException("Admin service is already running");
        }
        for (AbstractAdminCommand adminCommand : this.adminCommands) {
            if (!adminCommand.getCommandPath().equals(command.getCommandPath())) continue;
            throw new IllegalArgumentException("Another admin command is already registered under the path " + command.getCommandPath());
        }
        this.adminCommands.add(command);
    }

    public void registerShutdownTask(Runnable task) {
        if (task == null) {
            return;
        }
        if (this.adminService.isRunning()) {
            throw new IllegalStateException("Admin service is already running");
        }
        this.shutdownTasks.add(task);
    }

    public synchronized void start() {
        if (this.adminService.isRunning()) {
            throw new IllegalStateException("Admin service is already running");
        }
        ServletContextHandler commandContext = new ServletContextHandler((HandlerContainer)this.adminService, "/", false, false);
        commandContext.setDisplayName("Jetty Administration service");
        this.adminCommands.add(this.buildShutdownCommand());
        for (AbstractAdminCommand command : this.adminCommands) {
            ServletHolder servletHolder = new ServletHolder((Servlet)command);
            commandContext.addServlet(servletHolder, command.getCommandPath());
        }
        if (this.adminPassword != null) {
            FilterHolder passwordFiler = new FilterHolder((Filter)new PasswordProtectFilter(this.adminPassword));
            commandContext.addFilter(passwordFiler, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        JettyRunThread shutdownServiceRunThread = new JettyRunThread(this.adminService);
        shutdownServiceRunThread.start();
    }

    protected Server buildAdminService() {
        this.adminService = new Server();
        this.adminService.setSendServerVersion(false);
        this.adminService.setSendDateHeader(false);
        this.adminService.setStopAtShutdown(true);
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setHost(this.adminHost);
        connector.setPort(this.adminPort);
        this.adminService.setConnectors(new Connector[]{connector});
        return this.adminService;
    }

    protected AbstractAdminCommand buildShutdownCommand() {
        LazyList<Runnable> augmentedShutdownTasks = new LazyList<Runnable>();
        augmentedShutdownTasks.addAll(this.shutdownTasks);
        augmentedShutdownTasks.add(new JettyShutdownTask(this.adminService));
        return new ShutdownCommand(augmentedShutdownTasks);
    }
}

