/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.operator.GenericKey;

public abstract class PasswordRecipientInfoGenerator
implements RecipientInfoGenerator {
    private char[] password;
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private ASN1ObjectIdentifier kekAlgorithm;
    private SecureRandom random;
    private int schemeID;
    private int keySize;
    private int blockSize;

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        this(aSN1ObjectIdentifier, cArray, PasswordRecipientInfoGenerator.getKeySize(aSN1ObjectIdentifier), (Integer)PasswordRecipientInformation.BLOCKSIZES.get(aSN1ObjectIdentifier));
    }

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray, int n, int n2) {
        this.password = cArray;
        this.schemeID = 1;
        this.kekAlgorithm = aSN1ObjectIdentifier;
        this.keySize = n;
        this.blockSize = n2;
    }

    private static int getKeySize(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Integer n = (Integer)PasswordRecipientInformation.KEYSIZES.get(aSN1ObjectIdentifier);
        if (n == null) {
            throw new IllegalArgumentException("cannot find key size for algorithm: " + aSN1ObjectIdentifier);
        }
        return n;
    }

    public PasswordRecipientInfoGenerator setPasswordConversionScheme(int n) {
        this.schemeID = n;
        return this;
    }

    public PasswordRecipientInfoGenerator setSaltAndIterationCount(byte[] byArray, int n) {
        this.keyDerivationAlgorithm = new AlgorithmIdentifier((DERObjectIdentifier)PKCSObjectIdentifiers.id_PBKDF2, (DEREncodable)new PBKDF2Params(byArray, n));
        return this;
    }

    public PasswordRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
        Object object;
        byte[] byArray2 = new byte[this.blockSize];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray2);
        if (this.keyDerivationAlgorithm == null) {
            object = new byte[20];
            this.random.nextBytes((byte[])object);
            this.keyDerivationAlgorithm = new AlgorithmIdentifier((DERObjectIdentifier)PKCSObjectIdentifiers.id_PBKDF2, (DEREncodable)new PBKDF2Params(object, 1024));
        }
        object = PBKDF2Params.getInstance((Object)this.keyDerivationAlgorithm.getParameters());
        if (this.schemeID == 0) {
            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])this.password), object.getSalt(), object.getIterationCount().intValue());
            byArray = ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(this.keySize)).getKey();
        } else {
            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])this.password), object.getSalt(), object.getIterationCount().intValue());
            byArray = ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(this.keySize)).getKey();
        }
        pKCS5S2ParametersGenerator = new AlgorithmIdentifier((DERObjectIdentifier)this.kekAlgorithm, (DEREncodable)new DEROctetString(byArray2));
        byte[] byArray3 = this.generateEncryptedBytes((AlgorithmIdentifier)pKCS5S2ParametersGenerator, byArray, genericKey);
        DEROctetString dEROctetString = new DEROctetString(byArray3);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)this.kekAlgorithm);
        aSN1EncodableVector.add((DEREncodable)new DEROctetString(byArray2));
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((DERObjectIdentifier)PKCSObjectIdentifiers.id_alg_PWRI_KEK, (DEREncodable)new DERSequence(aSN1EncodableVector));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, algorithmIdentifier, (ASN1OctetString)dEROctetString));
    }

    protected abstract byte[] generateEncryptedBytes(AlgorithmIdentifier var1, byte[] var2, GenericKey var3) throws CMSException;
}

