# wallet 1.4

[![Build
status](https://travis-ci.org/rra/wallet.svg?branch=master)](https://travis-ci.org/rra/wallet)

Copyright 2014, 2016, 2018 Russ Allbery <eagle@eyrie.org>.  Copyright
2006-2010, 2012-2014 The Board of Trustees of the Leland Stanford Junior
University.  This software is distributed under a BSD-style license.
Please see the section [License](#license) below for more information.

## Blurb

The wallet is a system for managing secure data, authorization rules to
retrieve or change that data, and audit rules for documenting actions
taken on that data.  Objects of various types may be stored in the wallet
or generated on request and retrieved by authorized users.  The wallet
tracks ACLs, metadata, and trace information.  It is built on top of the
remctl protocol and uses Kerberos GSS-API authentication.  One of the
object types it supports is Kerberos keytabs, making it suitable as a
user-accessible front-end to Kerberos kadmind with richer ACL and metadata
operations.

## Description

The wallet is a client/server system using a central server with a
supporting database and a stand-alone client that can be widely
distributed to users.  The server runs on a secure host with access to a
local database; tracks object metadata such as ACLs, attributes, history,
expiration, and ownership; and has the necessary access privileges to
create wallet-managed objects in external systems (such as Kerberos
service principals).  The client uses the remctl protocol to send commands
to the server, store and retrieve objects, and query object metadata.  The
same client can be used for both regular user operations and wallet
administrative actions.

All wallet actions are controlled by a fine-grained set of ACLs.  Each
object has an owner ACL and optional get, store, show, destroy, and flags
ACLs that control more specific actions.  A global administrative ACL
controls access to administrative actions.  An ACL consists of zero or
more entries, each of which is a generic scheme and identifier pair,
allowing the ACL system to be extended to use any existing authorization
infrastructure.  Supported ACL types include Kerberos principal names,
regexes matching Kerberos principal names, and LDAP attribute checks.

Currently, the object types supported are simple files, passwords,
Kerberos keytabs, WebAuth keyrings, and Duo integrations.  By default,
whenever a Kerberos keytab object is retrieved from the wallet, the key is
changed in the Kerberos KDC and the wallet returns a keytab for the new
key.  However, a keytab object can also be configured to preserve the
existing keys when retrieved.  Included in the wallet distribution is a
script that can be run via remctl on an MIT Kerberos KDC to extract the
existing key for a principal, and the wallet system will use that
interface to retrieve the current key if the unchanging flag is set on a
Kerberos keytab object for MIT Kerberos.  (Heimdal doesn't require any
special support.)

## Requirements

The wallet client requires the C
[remctl](https://www.eyrie.org/~eagle/software/remctl/) client library and
a Kerberos library.  It will build with either MIT Kerberos or Heimdal.

The wallet server is written in Perl and requires Perl 5.8.0 or later plus
the following Perl modules:

* Date::Parse (part of the TimeDate distribution)
* DBI
* DBIx::Class
* Module::Build
* SQL::Translator

You will also need a DBD Perl module for the database backend that you
intend to use, and the DateTime::Format::* module corresponding to that
DBD module (such as DateTime::Format::SQLite or DateTime::Format::PG).

Currently, the server has only been tested against SQLite 3, MySQL 5, and
PostgreSQL, and prebuilt SQL files (for database upgrades) are only
provided for those servers.  It will probably not work fully with other
database backends.  Porting is welcome.

The wallet server is intended to be run under `remctld` and use `remctld`
to do authentication.  It can be ported to any other front-end, but doing
so will require writing a new version of `server/wallet-backend` that
translates the actions in that protocol into calls to the Wallet::Server
Perl object.

The keytab support in the wallet server supports Heimdal and MIT Kerberos
KDCs and has experimental support for Active Directory.  The Heimdal
support requires the Heimdal::Kadm5 Perl module.  The MIT Kerberos support
requires the MIT Kerberos `kadmin` client program be installed.  The
Active Directory support requires the Net::LDAP, Authen::SASL, and
IPC::Run Perl modules and the `msktutil` client program.

To support the unchanging flag on keytab objects with an MIT Kerberos KDC,
the Net::Remctl Perl module (shipped with remctl) must be installed on the
server and the `keytab-backend` script must be runnable via remctl on the
KDC.  This script also requires an MIT Kerberos `kadmin.local` binary that
supports the `-norandkey` option to `ktadd`.  This option is included in
MIT Kerberos 1.7 and later.

The WebAuth keyring object support in the wallet server requires the
WebAuth Perl module from WebAuth 4.4.0 or later.

The Duo integration object support in the wallet server requires the
Net::Duo, JSON, and Perl6::Slurp Perl modules.

The password object support in the wallet server requires the
Crypt::GeneratePassword Perl module.

The LDAP attribute ACL verifier requires the Authen::SASL and Net::LDAP
Perl modules.  This verifier only works with LDAP servers that support
GSS-API binds.

The NetDB ACL verifier (only of interest at sites using NetDB to manage
DNS) requires the Net::Remctl Perl module.

To bootstrap from a Git checkout, or if you change the Automake files and
need to regenerate Makefile.in, you will need Automake 1.11 or later.  For
bootstrap or if you change configure.ac or any of the m4 files it includes
and need to regenerate configure or config.h.in, you will need Autoconf
2.64 or later.  Perl is also required to generate manual pages from a
fresh Git checkout.

## Building and Installation

You can build and install wallet with the standard commands:

```
    ./configure
    make
    make install
```

If you are building from a Git clone, first run `./bootstrap` in the
source directory to generate the build files.  `make install` will
probably have to be done as root.  Building outside of the source
directory is also supported, if you wish, by creating an empty directory
and then running configure with the correct relative path.

If you are upgrading the wallet server from an earlier installed version,
run `wallet-admin upgrade` after installation to upgrade the database
schema.  See the wallet-admin manual page for more information.

You can pass the `--with-wallet-server` and `--with-wallet-port` options
to configure to compile in a default wallet server and port.  If no port
is set, the remctl default port is used.  If no server is set, the server
must be specified either in `krb5.conf` configuration or on the wallet
command line or the client will exit with an error.

By default, wallet uses whatever Perl executable exists in the current
`PATH`.  That Perl's path is what the server scripts will use, and that
Perl's configuration will be used to determine where the server Perl
modules will be installed.

To specify a particular Perl executable to use, either set the `PERL`
environment variable or pass it to configure like:

```
    ./configure PERL=/path/to/my/perl
```

By default, wallet installs itself under `/usr/local` except for the
server Perl modules, which are installed into whatever default site module
path is used by your Perl installation.  To change the installation
location of the files other than the Perl modules, pass the `--prefix=DIR`
argument to configure.

If remctl was installed in a path not normally searched by your compiler,
you must specify its installation prefix to configure with the
`--with-remctl=DIR` option, or alternately set the path to the include
files and libraries separately with `--with-remctl-include=DIR` and
`--with-remctl-lib=DIR`.

Normally, configure will use `krb5-config` to determine the flags to use
to compile with your Kerberos libraries.  To specify a particular
`krb5-config` script to use, either set the `PATH_KRB5_CONFIG` environment
variable or pass it to configure like:

```
    ./configure PATH_KRB5_CONFIG=/path/to/krb5-config
```

If `krb5-config` isn't found, configure will look for the standard
Kerberos libraries in locations already searched by your compiler.  If the
the `krb5-config` script first in your path is not the one corresponding
to the Kerberos libraries you want to use, or if your Kerberos libraries
and includes aren't in a location searched by default by your compiler,
you need to specify a different Kerberos installation root via
`--with-krb5=PATH`.  For example:

```
    ./configure --with-krb5=/usr/pubsw
```

You can also individually set the paths to the include directory and the
library directory with `--with-krb5-include` and `--with-krb5-lib`.  You
may need to do this if Autoconf can't figure out whether to use lib,
lib32, or lib64 on your platform.

To not use krb5-config and force library probing even if there is a
krb5-config script on your path, set PATH_KRB5_CONFIG to a nonexistent
path:

```
    ./configure PATH_KRB5_CONFIG=/nonexistent
```

`krb5-config` is not used and library probing is always done if either
`--with-krb5-include` or `--with-krb5-lib` are given.

Pass `--enable-silent-rules` to configure for a quieter build (similar to
the Linux kernel).  Use `make warnings` instead of `make` to build with
full GCC compiler warnings (requires either GCC or Clang and may require a
relatively current version of the compiler).

You can pass the `--enable-reduced-depends` flag to configure to try to
minimize the shared library dependencies encoded in the binaries.  This
omits from the link line all the libraries included solely because other
libraries depend on them and instead links the programs only against
libraries whose APIs are called directly.  This will only work with shared
libraries and will only work on platforms where shared libraries properly
encode their own dependencies (this includes most modern platforms such as
all Linux).  It is intended primarily for building packages for Linux
distributions to avoid encoding unnecessary shared library dependencies
that make shared library migrations more difficult.  If none of the above
made any sense to you, don't bother with this flag.

## Testing

The wallet comes with a comprehensive test suite, but it requires some
configuration in order to test anything other than low-level utility
functions.  To enable the full test suite, follow the instructions in:

* `tests/config/README`
* `perl/t/data/README`

Now, you can run the test suite with:

```
    make check
```

If a test fails, you can run a single test with verbose output via:

```
    tests/runtests -o <name-of-test>
```

Do this instead of running the test program directly since it will ensure
that necessary environment variables are set up.

The test suite requires `remctld` be installed and available in the user's
path or in `/usr/local/sbin` or `/usr/sbin`; and that `sqlite3`, `kinit`,
and either `kvno` or `kgetcred` be installed and available on the user's
path.  The test suite will also need to be able to bind to 127.0.0.1 on
ports 11119 and 14373 to test client/server network interactions.

The test suite uses a SQLite database for server-side and end-to-end
testing and therefore requires the DBD::SQLite and
DateTime::Format::SQLite Perl modules.

All of the requirements listed above will be required to run the full test
suite of server functionality, but tests will be selectively skipped if
their requirements aren't found.

The following additional Perl modules will be used if present:

* Test::MinimumVersion
* Test::Pod
* Test::Spelling
* Test::Strict

All are available on CPAN.  Those tests will be skipped if the modules are
not available.

To enable tests that don't detect functionality problems but are used to
sanity-check the release, set the environment variable `RELEASE_TESTING`
to a true value.  To enable tests that may be sensitive to the local
environment or that produce a lot of false positives without uncovering
many problems, set the environment variable `AUTHOR_TESTING` to a true
value.

## Configuration

Before setting up the wallet server, review the Wallet::Config
documentation (with man Wallet::Config or perldoc Wallet::Config).  There
are many customization options, some of which must be set.  You may also
need to create a Kerberos keytab for the keytab object backend and give it
appropriate ACLs, and set up `keytab-backend` and its `remctld`
configuration on your KDC if you want unchanging flag support.

For the basic setup and configuration of the wallet server, see the file
`docs/setup` in the source distribution.  You will need to set up a
database on the server (unless you're using SQLite), initialize the
database, install `remctld` and the wallet Perl modules, and set up
`remctld` to run the `wallet-backend` program.

The wallet client supports reading configuration settings from the system
`krb5.conf` file.  For more information, see the CONFIGURATION section of
the wallet client man page (`man wallet`).

## Support

The [wallet web page](https://www.eyrie.org/~eagle/software/wallet/) will
always have the current version of this package, the current
documentation, and pointers to any additional resources.

New wallet releases are announced on the kerberos mailing list.  To
subscribe or see the list archives, go to the [kerberos list information
page](https://mailman.mit.edu/mailman/listinfo/kerberos).

For bug tracking, use the [issue tracker on
GitHub](https://github.com/rra/wallet/issues).  However, please be aware
that I tend to be extremely busy and work projects often take priority.
I'll save your report and get to it as soon as I can, but it may take me a
couple of months.

## Source Repository

wallet is maintained using Git.  You can access the current source on
[GitHub](https://github.com/rra/wallet) or by cloning the repository at:

https://git.eyrie.org/git/kerberos/wallet.git

or [view the repository on the
web](https://git.eyrie.org/?p=kerberos/wallet.git).

The eyrie.org repository is the canonical one, maintained by the author,
but using GitHub is probably more convenient for most purposes.  Pull
requests are gratefully reviewed and normally accepted.

## License

The wallet package as a whole is covered by the following copyright
statement and license:

> Copyright 2014, 2016, 2018
>     Russ Allbery <eagle@eyrie.org>
>
> Copyright 2006-2010, 2012-2014
>     The Board of Trustees of the Leland Stanford Junior University
>
> Permission is hereby granted, free of charge, to any person obtaining a
> copy of this software and associated documentation files (the "Software"),
> to deal in the Software without restriction, including without limitation
> the rights to use, copy, modify, merge, publish, distribute, sublicense,
> and/or sell copies of the Software, and to permit persons to whom the
> Software is furnished to do so, subject to the following conditions:
>
> The above copyright notice and this permission notice shall be included in
> all copies or substantial portions of the Software.
>
> THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
> IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
> FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
> THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
> LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
> FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
> DEALINGS IN THE SOFTWARE.

Some files in this distribution are individually released under different
licenses, all of which are compatible with the above general package
license but which may require preservation of additional notices.  All
required notices, and detailed information about the licensing of each
file, are recorded in the LICENSE file.

Files covered by a license with an assigned SPDX License Identifier
include SPDX-License-Identifier tags to enable automated processing of
license information.  See https://spdx.org/licenses/ for more information.

For any copyright range specified by files in this package as YYYY-ZZZZ,
the range specifies every single year in that closed interval.
