/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.Arrays;

class IntArray {
    private static final int[] INTERLEAVE_TABLE = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};
    private static final String ZEROES = "00000000000000000000000000000000";
    private static final byte[] bitLengths = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private int[] m_ints;

    public static int getWordLength(int bits) {
        return bits + 31 >>> 5;
    }

    public IntArray(int intLen) {
        this.m_ints = new int[intLen];
    }

    public IntArray(int[] ints) {
        this.m_ints = ints;
    }

    public IntArray(BigInteger bigInt) {
        int barrI;
        if (bigInt == null || bigInt.signum() < 0) {
            throw new IllegalArgumentException("invalid F2m field value");
        }
        if (bigInt.signum() == 0) {
            this.m_ints = new int[]{0};
            return;
        }
        byte[] barr = bigInt.toByteArray();
        int barrLen = barr.length;
        int barrStart = 0;
        if (barr[0] == 0) {
            --barrLen;
            barrStart = 1;
        }
        int intLen = (barrLen + 3) / 4;
        this.m_ints = new int[intLen];
        int iarrJ = intLen - 1;
        int rem = barrLen % 4 + barrStart;
        int temp = 0;
        if (barrStart < rem) {
            for (barrI = barrStart; barrI < rem; ++barrI) {
                temp <<= 8;
                int barrBarrI = barr[barrI] & 0xFF;
                temp |= barrBarrI;
            }
            this.m_ints[iarrJ--] = temp;
        }
        while (iarrJ >= 0) {
            temp = 0;
            for (int i = 0; i < 4; ++i) {
                temp <<= 8;
                int barrBarrI = barr[barrI++] & 0xFF;
                temp |= barrBarrI;
            }
            this.m_ints[iarrJ] = temp;
            --iarrJ;
        }
    }

    public boolean isZero() {
        int[] a = this.m_ints;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int getUsedLength() {
        return this.getUsedLengthFrom(this.m_ints.length);
    }

    public int getUsedLengthFrom(int from) {
        int[] a = this.m_ints;
        if ((from = Math.min(from, a.length)) < 1) {
            return 0;
        }
        if (a[0] != 0) {
            while (a[--from] == 0) {
            }
            return from + 1;
        }
        do {
            if (a[--from] == 0) continue;
            return from + 1;
        } while (from > 0);
        return 0;
    }

    public int degree() {
        int w;
        int i = this.m_ints.length;
        do {
            if (i != 0) continue;
            return 0;
        } while ((w = this.m_ints[--i]) == 0);
        return (i << 5) + IntArray.bitLength(w);
    }

    private static int bitLength(int w) {
        int t = w >>> 16;
        if (t == 0) {
            t = w >>> 8;
            return t == 0 ? bitLengths[w] : 8 + bitLengths[t];
        }
        int u = t >>> 8;
        return u == 0 ? 16 + bitLengths[t] : 24 + bitLengths[u];
    }

    private int[] resizedInts(int newLen) {
        int[] newInts = new int[newLen];
        System.arraycopy(this.m_ints, 0, newInts, 0, Math.min(this.m_ints.length, newLen));
        return newInts;
    }

    public BigInteger toBigInteger() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return ECConstants.ZERO;
        }
        int highestInt = this.m_ints[usedLen - 1];
        byte[] temp = new byte[4];
        int barrI = 0;
        boolean trailingZeroBytesDone = false;
        for (int j = 3; j >= 0; --j) {
            byte thisByte = (byte)(highestInt >>> 8 * j);
            if (!trailingZeroBytesDone && thisByte == 0) continue;
            trailingZeroBytesDone = true;
            temp[barrI++] = thisByte;
        }
        int barrLen = 4 * (usedLen - 1) + barrI;
        byte[] barr = new byte[barrLen];
        for (int j = 0; j < barrI; ++j) {
            barr[j] = temp[j];
        }
        for (int iarrJ = usedLen - 2; iarrJ >= 0; --iarrJ) {
            for (int j = 3; j >= 0; --j) {
                barr[barrI++] = (byte)(this.m_ints[iarrJ] >>> 8 * j);
            }
        }
        return new BigInteger(1, barr);
    }

    private static int shiftLeft(int[] x, int count) {
        int prev = 0;
        for (int i = 0; i < count; ++i) {
            int next = x[i];
            x[i] = next << 1 | prev;
            prev = next >>> 31;
        }
        return prev;
    }

    public void addOneShifted(int shift) {
        if (shift >= this.m_ints.length) {
            this.m_ints = this.resizedInts(shift + 1);
        }
        int n = shift;
        this.m_ints[n] = this.m_ints[n] ^ 1;
    }

    private void addShiftedByBits(IntArray other, int bits) {
        int words = bits >>> 5;
        int shift = bits & 0x1F;
        if (shift == 0) {
            this.addShiftedByWords(other, words);
            return;
        }
        int otherUsedLen = other.getUsedLength();
        if (otherUsedLen == 0) {
            return;
        }
        int minLen = otherUsedLen + words + 1;
        if (minLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(minLen);
        }
        int shiftInv = 32 - shift;
        int prev = 0;
        for (int i = 0; i < otherUsedLen; ++i) {
            int next = other.m_ints[i];
            int n = i + words;
            this.m_ints[n] = this.m_ints[n] ^ (next << shift | prev);
            prev = next >>> shiftInv;
        }
        int n = otherUsedLen + words;
        this.m_ints[n] = this.m_ints[n] ^ prev;
    }

    private static int addShiftedByBits(int[] x, int[] y, int count, int shift) {
        int shiftInv = 32 - shift;
        int prev = 0;
        int i = 0;
        while (i < count) {
            int next = y[i];
            int n = i++;
            x[n] = x[n] ^ (next << shift | prev);
            prev = next >>> shiftInv;
        }
        return prev;
    }

    private static int addShiftedByBits(int[] x, int xOff, int[] y, int yOff, int count, int shift) {
        int shiftInv = 32 - shift;
        int prev = 0;
        for (int i = 0; i < count; ++i) {
            int next = y[yOff + i];
            int n = xOff + i;
            x[n] = x[n] ^ (next << shift | prev);
            prev = next >>> shiftInv;
        }
        return prev;
    }

    public void addShiftedByWords(IntArray other, int words) {
        int otherUsedLen = other.getUsedLength();
        if (otherUsedLen == 0) {
            return;
        }
        int minLen = otherUsedLen + words;
        if (minLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(minLen);
        }
        for (int i = 0; i < otherUsedLen; ++i) {
            int n = words + i;
            this.m_ints[n] = this.m_ints[n] ^ other.m_ints[i];
        }
    }

    private static void addShiftedByWords(int[] x, int xOff, int[] y, int count) {
        for (int i = 0; i < count; ++i) {
            int n = xOff + i;
            x[n] = x[n] ^ y[i];
        }
    }

    private static void add(int[] x, int[] y, int count) {
        for (int i = 0; i < count; ++i) {
            int n = i;
            x[n] = x[n] ^ y[i];
        }
    }

    private static void distribute(int[] x, int dst1, int dst2, int src, int count) {
        for (int i = 0; i < count; ++i) {
            int v = x[src + i];
            int n = dst1 + i;
            x[n] = x[n] ^ v;
            int n2 = dst2 + i;
            x[n2] = x[n2] ^ v;
        }
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public void flipWord(int bit, int word) {
        int n = bit >>> 5;
        int len = this.m_ints.length;
        if (n < len) {
            int shift = bit & 0x1F;
            if (shift == 0) {
                int n2 = n;
                this.m_ints[n2] = this.m_ints[n2] ^ word;
            } else {
                int n3 = n++;
                this.m_ints[n3] = this.m_ints[n3] ^ word << shift;
                if (n < len) {
                    int n4 = n;
                    this.m_ints[n4] = this.m_ints[n4] ^ word >>> 32 - shift;
                }
            }
        }
    }

    public int getWord(int bit) {
        int n = bit >>> 5;
        int len = this.m_ints.length;
        if (n >= len) {
            return 0;
        }
        int shift = bit & 0x1F;
        if (shift == 0) {
            return this.m_ints[n];
        }
        int result = this.m_ints[n] >>> shift;
        if (++n < len) {
            result |= this.m_ints[n] << 32 - shift;
        }
        return result;
    }

    public boolean testBitZero() {
        return this.m_ints.length > 0 && (this.m_ints[0] & 1) != 0;
    }

    public boolean testBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int tester = 1 << theBit;
        return (this.m_ints[theInt] & tester) != 0;
    }

    public void flipBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int flipper = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] ^ flipper;
    }

    public void setBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int setter = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] | setter;
    }

    public void clearBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int setter = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] & ~setter;
    }

    public IntArray multiply(IntArray other, int m) {
        int aLen = this.getUsedLength();
        if (aLen == 0) {
            return new IntArray(1);
        }
        int bLen = other.getUsedLength();
        if (bLen == 0) {
            return new IntArray(1);
        }
        IntArray A = this;
        IntArray B = other;
        if (aLen > bLen) {
            A = other;
            B = this;
            int tmp = aLen;
            aLen = bLen;
            bLen = tmp;
        }
        if (aLen == 1) {
            int a = A.m_ints[0];
            int[] b = B.m_ints;
            int[] c = new int[aLen + bLen];
            if ((a & 1) != 0) {
                IntArray.add(c, b, bLen);
            }
            int k = 1;
            while ((a >>>= 1) != 0) {
                if ((a & 1) != 0) {
                    IntArray.addShiftedByBits(c, b, bLen, k);
                }
                ++k;
            }
            return new IntArray(c);
        }
        int complexity = aLen <= 8 ? 1 : 2;
        int width = 1 << complexity;
        int shifts = 32 >>> complexity;
        int bExt = bLen;
        if (B.m_ints[bLen - 1] >>> 33 - shifts != 0) {
            ++bExt;
        }
        int cLen = bExt + aLen;
        int[] c = new int[cLen << width];
        System.arraycopy(B.m_ints, 0, c, 0, bLen);
        IntArray.interleave(A.m_ints, 0, c, bExt, aLen, complexity);
        int[] ci = new int[1 << width];
        for (int i = 1; i < ci.length; ++i) {
            ci[i] = ci[i - 1] + cLen;
        }
        int MASK = (1 << width) - 1;
        int k = 0;
        while (true) {
            for (int aPos = 0; aPos < aLen; ++aPos) {
                int index = c[bExt + aPos] >>> k & MASK;
                if (index == 0) continue;
                IntArray.addShiftedByWords(c, aPos + ci[index], c, bExt);
            }
            if ((k += width) >= 32) break;
            IntArray.shiftLeft(c, bExt);
        }
        int ciPos = ci.length;
        int pow2 = ciPos >>> 1;
        int offset = 32;
        while (--ciPos > 1) {
            if (ciPos == pow2) {
                IntArray.addShiftedByBits(c, ci[1], c, ci[pow2], cLen, offset -= shifts);
                pow2 >>>= 1;
                continue;
            }
            IntArray.distribute(c, ci[pow2], ci[ciPos - pow2], ci[ciPos], cLen);
        }
        IntArray p = new IntArray(cLen);
        System.arraycopy(c, ci[1], p.m_ints, 0, cLen);
        return p;
    }

    public void reduce(int m, int[] ks) {
        int mLen;
        int len = this.getUsedLength();
        if (len < (mLen = m + 31 >>> 5)) {
            return;
        }
        int _2m = m << 1;
        int pos = Math.min(_2m - 2, (len << 5) - 1);
        int kMax = ks[ks.length - 1];
        if (kMax < m - 31) {
            this.reduceWordWise(pos, m, ks);
        } else {
            this.reduceBitWise(pos, m, ks);
        }
        int partial = m & 0x1F;
        if (partial != 0) {
            int n = mLen - 1;
            this.m_ints[n] = this.m_ints[n] & (1 << partial) - 1;
        }
        if (len > mLen) {
            this.m_ints = this.resizedInts(mLen);
        }
    }

    private void reduceBitWise(int from, int m, int[] ks) {
        for (int i = from; i >= m; --i) {
            if (!this.testBit(i)) continue;
            int bit = i - m;
            this.flipBit(bit);
            int j = ks.length;
            while (--j >= 0) {
                this.flipBit(ks[j] + bit);
            }
        }
    }

    private void reduceWordWise(int from, int m, int[] ks) {
        int pos;
        for (int i = pos = m + (from - m & 0xFFFFFFE0); i >= m; i -= 32) {
            int word = this.getWord(i);
            if (word == 0) continue;
            int bit = i - m;
            this.flipWord(bit, word);
            int j = ks.length;
            while (--j >= 0) {
                this.flipWord(ks[j] + bit, word);
            }
        }
    }

    public IntArray square(int m) {
        int len = this.getUsedLength();
        if (len == 0) {
            return this;
        }
        int _2len = len << 1;
        int[] r = new int[_2len];
        int pos = 0;
        while (pos < _2len) {
            int mi = this.m_ints[pos >>> 1];
            r[pos++] = IntArray.interleave16(mi & 0xFFFF);
            r[pos++] = IntArray.interleave16(mi >>> 16);
        }
        return new IntArray(r);
    }

    private static void interleave(int[] x, int xOff, int[] z, int zOff, int count, int rounds) {
        for (int i = 0; i < count; ++i) {
            z[zOff + i] = IntArray.interleave(x[xOff + i], rounds);
        }
    }

    private static int interleave(int x, int rounds) {
        while (--rounds >= 0) {
            x = IntArray.interleave16(x & 0xFFFF) | IntArray.interleave16(x >>> 16) << 1;
        }
        return x;
    }

    private static int interleave16(int n) {
        return INTERLEAVE_TABLE[n & 0xFF] | INTERLEAVE_TABLE[n >>> 8] << 16;
    }

    public IntArray modInverse(int m, int[] ks) {
        int uzDegree = this.degree();
        if (uzDegree == 1) {
            return this;
        }
        IntArray uz = (IntArray)this.clone();
        int t = IntArray.getWordLength(m);
        IntArray vz = new IntArray(t);
        vz.setBit(m);
        vz.setBit(0);
        vz.setBit(ks[0]);
        if (ks.length > 1) {
            vz.setBit(ks[1]);
            vz.setBit(ks[2]);
        }
        IntArray g1z = new IntArray(t);
        g1z.setBit(0);
        IntArray g2z = new IntArray(t);
        while (uzDegree != 0) {
            int j = uzDegree - vz.degree();
            if (j < 0) {
                IntArray uzCopy = uz;
                uz = vz;
                vz = uzCopy;
                IntArray g1zCopy = g1z;
                g1z = g2z;
                g2z = g1zCopy;
                j = -j;
            }
            uz.addShiftedByBits(vz, j);
            uzDegree = uz.degree();
            if (uzDegree == 0) continue;
            g1z.addShiftedByBits(g2z, j);
        }
        return g2z;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntArray)) {
            return false;
        }
        IntArray other = (IntArray)o;
        int usedLen = this.getUsedLength();
        if (other.getUsedLength() != usedLen) {
            return false;
        }
        for (int i = 0; i < usedLen; ++i) {
            if (this.m_ints[i] == other.m_ints[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int usedLen = this.getUsedLength();
        int hash = 1;
        for (int i = 0; i < usedLen; ++i) {
            hash *= 31;
            hash ^= this.m_ints[i];
        }
        return hash;
    }

    public Object clone() {
        return new IntArray(Arrays.clone(this.m_ints));
    }

    public String toString() {
        int i = this.getUsedLength();
        if (i == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer(Integer.toBinaryString(this.m_ints[--i]));
        while (--i >= 0) {
            String s = Integer.toBinaryString(this.m_ints[i]);
            int len = s.length();
            if (len < 32) {
                sb.append(ZEROES.substring(len));
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

