/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.finder.AbstractFinder;
import com.sun.beans.finder.PrimitiveWrapperMap;
import com.sun.beans.finder.Signature;
import com.sun.beans.finder.SignatureException;
import com.sun.beans.util.Cache;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import sun.reflect.misc.ReflectUtil;

public final class ConstructorFinder
extends AbstractFinder<Constructor<?>> {
    private static final Cache<Signature, Constructor<?>> CACHE = new Cache<Signature, Constructor<?>>(Cache.Kind.SOFT, Cache.Kind.SOFT){

        @Override
        public Constructor create(Signature signature) {
            try {
                ConstructorFinder finder = new ConstructorFinder(signature.getArgs());
                return (Constructor)finder.find(signature.getType().getConstructors());
            }
            catch (Exception exception) {
                throw new SignatureException(exception);
            }
        }
    };

    public static Constructor<?> findConstructor(Class<?> type, Class<?> ... args) throws NoSuchMethodException {
        if (type.isPrimitive()) {
            throw new NoSuchMethodException("Primitive wrapper does not contain constructors");
        }
        if (type.isInterface()) {
            throw new NoSuchMethodException("Interface does not contain constructors");
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new NoSuchMethodException("Abstract class cannot be instantiated");
        }
        if (!Modifier.isPublic(type.getModifiers()) || !ReflectUtil.isPackageAccessible(type)) {
            throw new NoSuchMethodException("Class is not accessible");
        }
        PrimitiveWrapperMap.replacePrimitivesWithWrappers(args);
        Signature signature = new Signature(type, args);
        try {
            return CACHE.get(signature);
        }
        catch (SignatureException exception) {
            throw exception.toNoSuchMethodException("Constructor is not found");
        }
    }

    private ConstructorFinder(Class<?>[] args) {
        super(args);
    }
}

