/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class ElectronicCodeBook
extends FeedbackCipher {
    ElectronicCodeBook(SymmetricCipher embeddedCipher) {
        super(embeddedCipher);
    }

    @Override
    String getFeedback() {
        return "ECB";
    }

    @Override
    void reset() {
    }

    @Override
    void save() {
    }

    @Override
    void restore() {
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException {
        if (key == null || iv != null) {
            throw new InvalidKeyException("Internal error");
        }
        this.embeddedCipher.init(decrypting, algorithm, key);
    }

    @Override
    int encrypt(byte[] in, int inOff, int len, byte[] out, int outOff) {
        for (int i = len; i >= this.blockSize; i -= this.blockSize) {
            this.embeddedCipher.encryptBlock(in, inOff, out, outOff);
            inOff += this.blockSize;
            outOff += this.blockSize;
        }
        return len;
    }

    @Override
    int decrypt(byte[] in, int inOff, int len, byte[] out, int outOff) {
        for (int i = len; i >= this.blockSize; i -= this.blockSize) {
            this.embeddedCipher.decryptBlock(in, inOff, out, outOff);
            inOff += this.blockSize;
            outOff += this.blockSize;
        }
        return len;
    }
}

