/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.LongArray;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract String getFieldName();

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement addOne();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public int bitLength() {
        return this.toBigInteger().bitLength();
    }

    public boolean isZero() {
        return 0 == this.toBigInteger().signum();
    }

    public boolean testBitZero() {
        return this.toBigInteger().testBit(0);
    }

    public String toString() {
        return this.toBigInteger().toString(16);
    }

    public byte[] getEncoded() {
        return BigIntegers.asUnsignedByteArray((this.getFieldSize() + 7) / 8, this.toBigInteger());
    }

    public static class F2m
    extends ECFieldElement {
        public static final int GNB = 1;
        public static final int TPB = 2;
        public static final int PPB = 3;
        private int representation;
        private int m;
        private int[] ks;
        private LongArray x;

        public F2m(int m, int k1, int k2, int k3, BigInteger x) {
            if (k2 == 0 && k3 == 0) {
                this.representation = 2;
                this.ks = new int[]{k1};
            } else {
                if (k2 >= k3) {
                    throw new IllegalArgumentException("k2 must be smaller than k3");
                }
                if (k2 <= 0) {
                    throw new IllegalArgumentException("k2 must be larger than 0");
                }
                this.representation = 3;
                this.ks = new int[]{k1, k2, k3};
            }
            this.m = m;
            this.x = new LongArray(x);
        }

        public F2m(int m, int k, BigInteger x) {
            this(m, k, 0, 0, x);
        }

        private F2m(int m, int[] ks, LongArray x) {
            this.m = m;
            this.representation = ks.length == 1 ? 2 : 3;
            this.ks = ks;
            this.x = x;
        }

        @Override
        public int bitLength() {
            return this.x.degree();
        }

        @Override
        public boolean isZero() {
            return this.x.isZero();
        }

        @Override
        public boolean testBitZero() {
            return this.x.testBitZero();
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x.toBigInteger();
        }

        @Override
        public String getFieldName() {
            return "F2m";
        }

        @Override
        public int getFieldSize() {
            return this.m;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement b) {
            if (!(a instanceof F2m) || !(b instanceof F2m)) {
                throw new IllegalArgumentException("Field elements are not both instances of ECFieldElement.F2m");
            }
            F2m aF2m = (F2m)a;
            F2m bF2m = (F2m)b;
            if (aF2m.representation != bF2m.representation) {
                throw new IllegalArgumentException("One of the F2m field elements has incorrect representation");
            }
            if (aF2m.m != bF2m.m || !Arrays.areEqual(aF2m.ks, bF2m.ks)) {
                throw new IllegalArgumentException("Field elements are not elements of the same field F2m");
            }
        }

        @Override
        public ECFieldElement add(ECFieldElement b) {
            LongArray iarrClone = (LongArray)this.x.clone();
            F2m bF2m = (F2m)b;
            iarrClone.addShiftedByWords(bF2m.x, 0);
            return new F2m(this.m, this.ks, iarrClone);
        }

        @Override
        public ECFieldElement addOne() {
            return new F2m(this.m, this.ks, this.x.addOne());
        }

        @Override
        public ECFieldElement subtract(ECFieldElement b) {
            return this.add(b);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement b) {
            return new F2m(this.m, this.ks, this.x.modMultiply(((F2m)b).x, this.m, this.ks));
        }

        @Override
        public ECFieldElement divide(ECFieldElement b) {
            ECFieldElement bInv = b.invert();
            return this.multiply(bInv);
        }

        @Override
        public ECFieldElement negate() {
            return this;
        }

        @Override
        public ECFieldElement square() {
            return new F2m(this.m, this.ks, this.x.modSquare(this.m, this.ks));
        }

        @Override
        public ECFieldElement invert() {
            return new F2m(this.m, this.ks, this.x.modInverse(this.m, this.ks));
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException("Not implemented");
        }

        public int getRepresentation() {
            return this.representation;
        }

        public int getM() {
            return this.m;
        }

        public int getK1() {
            return this.ks[0];
        }

        public int getK2() {
            return this.ks.length >= 2 ? this.ks[1] : 0;
        }

        public int getK3() {
            return this.ks.length >= 3 ? this.ks[2] : 0;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof F2m)) {
                return false;
            }
            F2m b = (F2m)anObject;
            return this.m == b.m && this.representation == b.representation && Arrays.areEqual(this.ks, b.ks) && this.x.equals(b.x);
        }

        public int hashCode() {
            return this.x.hashCode() ^ this.m ^ Arrays.hashCode(this.ks);
        }
    }

    public static class Fp
    extends ECFieldElement {
        BigInteger q;
        BigInteger r;
        BigInteger x;

        static BigInteger calculateResidue(BigInteger p) {
            BigInteger firstWord;
            int bitLength = p.bitLength();
            if (bitLength > 128 && (firstWord = p.shiftRight(bitLength - 64)).longValue() == -1L) {
                return ONE.shiftLeft(bitLength).subtract(p);
            }
            return null;
        }

        public Fp(BigInteger q, BigInteger x) {
            this(q, Fp.calculateResidue(q), x);
        }

        Fp(BigInteger q, BigInteger r, BigInteger x) {
            if (x == null || x.signum() < 0 || x.compareTo(q) >= 0) {
                throw new IllegalArgumentException("x value invalid in Fp field element");
            }
            this.q = q;
            this.r = r;
            this.x = x;
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x;
        }

        @Override
        public String getFieldName() {
            return "Fp";
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public ECFieldElement add(ECFieldElement b) {
            return new Fp(this.q, this.r, this.modAdd(this.x, b.toBigInteger()));
        }

        @Override
        public ECFieldElement addOne() {
            BigInteger x2 = this.x.add(ECConstants.ONE);
            if (x2.compareTo(this.q) == 0) {
                x2 = ECConstants.ZERO;
            }
            return new Fp(this.q, this.r, x2);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement b) {
            BigInteger x2 = b.toBigInteger();
            BigInteger x3 = this.x.subtract(x2);
            if (x3.signum() < 0) {
                x3 = x3.add(this.q);
            }
            return new Fp(this.q, this.r, x3);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement b) {
            return new Fp(this.q, this.r, this.modMult(this.x, b.toBigInteger()));
        }

        @Override
        public ECFieldElement divide(ECFieldElement b) {
            return new Fp(this.q, this.modMult(this.x, b.toBigInteger().modInverse(this.q)));
        }

        @Override
        public ECFieldElement negate() {
            BigInteger x2 = this.x.signum() == 0 ? this.x : (ONE.equals(this.r) ? this.q.xor(this.x) : this.q.subtract(this.x));
            return new Fp(this.q, this.r, x2);
        }

        @Override
        public ECFieldElement square() {
            return new Fp(this.q, this.r, this.modMult(this.x, this.x));
        }

        @Override
        public ECFieldElement invert() {
            return new Fp(this.q, this.r, this.x.modInverse(this.q));
        }

        @Override
        public ECFieldElement sqrt() {
            if (!this.q.testBit(0)) {
                throw new RuntimeException("not done yet");
            }
            if (this.q.testBit(1)) {
                Fp z = new Fp(this.q, this.r, this.x.modPow(this.q.shiftRight(2).add(ECConstants.ONE), this.q));
                return ((ECFieldElement)z).square().equals(this) ? z : null;
            }
            BigInteger qMinusOne = this.q.subtract(ECConstants.ONE);
            BigInteger legendreExponent = qMinusOne.shiftRight(1);
            if (!this.x.modPow(legendreExponent, this.q).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger u = qMinusOne.shiftRight(2);
            BigInteger k = u.shiftLeft(1).add(ECConstants.ONE);
            BigInteger Q = this.x;
            BigInteger fourQ = this.modDouble(this.modDouble(Q));
            Random rand = new Random();
            while (true) {
                BigInteger P;
                if ((P = new BigInteger(this.q.bitLength(), rand)).compareTo(this.q) >= 0 || !P.multiply(P).subtract(fourQ).modPow(legendreExponent, this.q).equals(qMinusOne)) {
                    continue;
                }
                BigInteger[] result = this.lucasSequence(P, Q, k);
                BigInteger U = result[0];
                BigInteger V = result[1];
                if (this.modMult(V, V).equals(fourQ)) {
                    if (V.testBit(0)) {
                        V = V.add(this.q);
                    }
                    V = V.shiftRight(1);
                    return new Fp(this.q, this.r, V);
                }
                if (!U.equals(ECConstants.ONE) && !U.equals(qMinusOne)) break;
            }
            return null;
        }

        private BigInteger[] lucasSequence(BigInteger P, BigInteger Q, BigInteger k) {
            int j;
            int n = k.bitLength();
            int s = k.getLowestSetBit();
            BigInteger Uh = ECConstants.ONE;
            BigInteger Vl = ECConstants.TWO;
            BigInteger Vh = P;
            BigInteger Ql = ECConstants.ONE;
            BigInteger Qh = ECConstants.ONE;
            for (j = n - 1; j >= s + 1; --j) {
                Ql = this.modMult(Ql, Qh);
                if (k.testBit(j)) {
                    Qh = this.modMult(Ql, Q);
                    Uh = this.modMult(Uh, Vh);
                    Vl = this.modReduce(Vh.multiply(Vl).subtract(P.multiply(Ql)));
                    Vh = this.modReduce(Vh.multiply(Vh).subtract(Qh.shiftLeft(1)));
                    continue;
                }
                Qh = Ql;
                Uh = this.modReduce(Uh.multiply(Vl).subtract(Ql));
                Vh = this.modReduce(Vh.multiply(Vl).subtract(P.multiply(Ql)));
                Vl = this.modReduce(Vl.multiply(Vl).subtract(Ql.shiftLeft(1)));
            }
            Ql = this.modMult(Ql, Qh);
            Qh = this.modMult(Ql, Q);
            Uh = this.modReduce(Uh.multiply(Vl).subtract(Ql));
            Vl = this.modReduce(Vh.multiply(Vl).subtract(P.multiply(Ql)));
            Ql = this.modMult(Ql, Qh);
            for (j = 1; j <= s; ++j) {
                Uh = this.modMult(Uh, Vl);
                Vl = this.modReduce(Vl.multiply(Vl).subtract(Ql.shiftLeft(1)));
                Ql = this.modMult(Ql, Ql);
            }
            return new BigInteger[]{Uh, Vl};
        }

        protected BigInteger modAdd(BigInteger x1, BigInteger x2) {
            BigInteger x3 = x1.add(x2);
            if (x3.compareTo(this.q) >= 0) {
                x3 = x3.subtract(this.q);
            }
            return x3;
        }

        protected BigInteger modDouble(BigInteger x) {
            BigInteger _2x = x.shiftLeft(1);
            if (_2x.compareTo(this.q) >= 0) {
                _2x = _2x.subtract(this.q);
            }
            return _2x;
        }

        protected BigInteger modMult(BigInteger x1, BigInteger x2) {
            return this.modReduce(x1.multiply(x2));
        }

        protected BigInteger modReduce(BigInteger x) {
            if (this.r != null) {
                int qLen = this.q.bitLength();
                while (x.bitLength() > qLen + 1) {
                    BigInteger u = x.shiftRight(qLen);
                    BigInteger v = x.subtract(u.shiftLeft(qLen));
                    if (!this.r.equals(ONE)) {
                        u = u.multiply(this.r);
                    }
                    x = u.add(v);
                }
                while (x.compareTo(this.q) >= 0) {
                    x = x.subtract(this.q);
                }
            } else {
                x = x.mod(this.q);
            }
            return x;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Fp)) {
                return false;
            }
            Fp o = (Fp)other;
            return this.q.equals(o.q) && this.x.equals(o.x);
        }

        public int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }
}

