/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public class CipherStreamTest2
extends SimpleTest {
    @Override
    public String getName() {
        return "CipherStreamTest";
    }

    private void testModes(String algo, String[] transforms, boolean authenticated) throws Exception {
        Key key = CipherStreamTest2.generateKey(algo);
        for (int i = 0; i != transforms.length; ++i) {
            String transform = transforms[i];
            this.testWriteRead(algo + transform, key, authenticated, true, false);
            this.testWriteRead(algo + transform, key, authenticated, true, true);
            this.testWriteRead(algo + transform, key, authenticated, false, false);
            this.testWriteRead(algo + transform, key, authenticated, false, true);
            this.testReadWrite(algo + transform, key, authenticated, true, false);
            this.testReadWrite(algo + transform, key, authenticated, true, true);
            this.testReadWrite(algo + transform, key, authenticated, false, false);
            this.testReadWrite(algo + transform, key, authenticated, false, true);
            if (transform.indexOf("CTS") <= -1) {
                this.testWriteReadEmpty(algo + transform, key, authenticated, true, false);
                this.testWriteReadEmpty(algo + transform, key, authenticated, true, true);
                this.testWriteReadEmpty(algo + transform, key, authenticated, false, false);
                this.testWriteReadEmpty(algo + transform, key, authenticated, false, true);
            }
            if (!authenticated) continue;
            this.testTamperedRead(algo + transform, key, true, true);
            this.testTamperedRead(algo + transform, key, true, false);
            this.testTruncatedRead(algo + transform, key, true, true);
            this.testTruncatedRead(algo + transform, key, true, false);
            this.testTamperedWrite(algo + transform, key, true, true);
            this.testTamperedWrite(algo + transform, key, true, false);
        }
    }

    private InputStream createInputStream(byte[] data, Cipher cipher, boolean useBc) {
        ByteArrayInputStream bytes = new ByteArrayInputStream(data);
        return useBc ? new CipherInputStream(bytes, cipher) : new javax.crypto.CipherInputStream(bytes, cipher);
    }

    private OutputStream createOutputStream(ByteArrayOutputStream bytes, Cipher cipher, boolean useBc) {
        return useBc ? new CipherOutputStream(bytes, cipher) : new javax.crypto.CipherOutputStream(bytes, cipher);
    }

    private void testTamperedRead(String name, Key key, boolean authenticated, boolean useBc) throws Exception {
        Cipher encrypt = Cipher.getInstance(name, "BC");
        Cipher decrypt = Cipher.getInstance(name, "BC");
        encrypt.init(1, key);
        if (encrypt.getIV() != null) {
            decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
        } else {
            decrypt.init(2, key);
        }
        byte[] ciphertext = encrypt.doFinal(new byte[1000]);
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        InputStream input = this.createInputStream(ciphertext, decrypt, useBc);
        try {
            while (input.read() >= 0) {
            }
            this.fail("Expected invalid ciphertext after tamper and read : " + name, authenticated, useBc);
        }
        catch (InvalidCipherTextIOException e) {
            // empty catch block
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception : " + name, e, authenticated, useBc);
        }
    }

    private void testTruncatedRead(String name, Key key, boolean authenticated, boolean useBc) throws Exception {
        InputStream input;
        block8: {
            int read;
            Cipher encrypt = Cipher.getInstance(name, "BC");
            Cipher decrypt = Cipher.getInstance(name, "BC");
            encrypt.init(1, key);
            if (encrypt.getIV() != null) {
                decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
            } else {
                decrypt.init(2, key);
            }
            byte[] ciphertext = encrypt.doFinal(new byte[1000]);
            byte[] truncated = new byte[ciphertext.length - 1000 - 1];
            System.arraycopy(ciphertext, 0, truncated, 0, truncated.length);
            ciphertext[0] = (byte)(ciphertext[0] + 1);
            input = this.createInputStream(truncated, decrypt, useBc);
            do {
                read = 0;
                try {
                    read = input.read();
                }
                catch (InvalidCipherTextIOException e) {
                    break block8;
                }
                catch (Exception e) {
                    this.fail("Unexpected exception : " + name, e, authenticated, useBc);
                    break block8;
                }
            } while (read >= 0);
            this.fail("Expected invalid ciphertext after truncate and read : " + name, authenticated, useBc);
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception : " + name, e, authenticated, useBc);
        }
    }

    private void testTamperedWrite(String name, Key key, boolean authenticated, boolean useBc) throws Exception {
        Cipher encrypt = Cipher.getInstance(name, "BC");
        Cipher decrypt = Cipher.getInstance(name, "BC");
        encrypt.init(1, key);
        if (encrypt.getIV() != null) {
            decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
        } else {
            decrypt.init(2, key);
        }
        byte[] ciphertext = encrypt.doFinal(new byte[1000]);
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        OutputStream output = this.createOutputStream(plaintext, decrypt, useBc);
        for (int i = 0; i < ciphertext.length; ++i) {
            output.write(ciphertext[i]);
        }
        try {
            output.close();
            this.fail("Expected invalid ciphertext after tamper and write : " + name, authenticated, useBc);
        }
        catch (InvalidCipherTextIOException e) {
            // empty catch block
        }
    }

    private void testWriteRead(String name, Key key, boolean authenticated, boolean useBc, boolean blocks) throws Exception {
        byte[] data = new byte[1000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        this.testWriteRead(name, key, authenticated, useBc, blocks, data);
    }

    private void testWriteReadEmpty(String name, Key key, boolean authenticated, boolean useBc, boolean blocks) throws Exception {
        byte[] data = new byte[]{};
        this.testWriteRead(name, key, authenticated, useBc, blocks, data);
    }

    private void testWriteRead(String name, Key key, boolean authenticated, boolean useBc, boolean blocks, byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Cipher encrypt = Cipher.getInstance(name, "BC");
            Cipher decrypt = Cipher.getInstance(name, "BC");
            encrypt.init(1, key);
            if (encrypt.getIV() != null) {
                decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
            } else {
                decrypt.init(2, key);
            }
            OutputStream cOut = this.createOutputStream(bOut, encrypt, useBc);
            if (blocks) {
                int chunkSize = data.length / 8;
                for (int i = 0; i < data.length; i += chunkSize) {
                    cOut.write(data, i, chunkSize);
                }
            } else {
                for (int i = 0; i < data.length; ++i) {
                    cOut.write(data[i]);
                }
            }
            cOut.close();
            byte[] cipherText = bOut.toByteArray();
            bOut.reset();
            InputStream cIn = this.createInputStream(cipherText, decrypt, useBc);
            if (blocks) {
                int c;
                byte[] block = new byte[encrypt.getBlockSize() + 1];
                while ((c = cIn.read(block)) >= 0) {
                    bOut.write(block, 0, c);
                }
            } else {
                int c;
                while ((c = cIn.read()) >= 0) {
                    bOut.write(c);
                }
            }
            cIn.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + name, e, authenticated, useBc);
        }
        byte[] decrypted = bOut.toByteArray();
        if (!Arrays.areEqual(data, decrypted)) {
            this.fail("Failed - decrypted data doesn't match: " + name, authenticated, useBc);
        }
    }

    protected void fail(String message, boolean authenticated, boolean bc) {
        if (bc || !authenticated) {
            super.fail(message);
        }
    }

    protected void fail(String message, Throwable throwable, boolean authenticated, boolean bc) {
        if (bc || !authenticated) {
            super.fail(message, throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    private void testReadWrite(String name, Key key, boolean authenticated, boolean useBc, boolean blocks) throws Exception {
        String lCode = "ABCDEFGHIJKLMNOPQRSTU";
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Cipher in = Cipher.getInstance(name, "BC");
            Cipher out = Cipher.getInstance(name, "BC");
            in.init(1, key);
            if (in.getIV() != null) {
                out.init(2, key, new IvParameterSpec(in.getIV()));
            } else {
                out.init(2, key);
            }
            InputStream cIn = this.createInputStream(lCode.getBytes(), in, useBc);
            OutputStream cOut = this.createOutputStream(bOut, out, useBc);
            if (blocks) {
                int c;
                byte[] block = new byte[in.getBlockSize() + 1];
                while ((c = cIn.read(block)) >= 0) {
                    cOut.write(block, 0, c);
                }
            } else {
                int c;
                while ((c = cIn.read()) >= 0) {
                    cOut.write(c);
                }
            }
            cIn.close();
            cOut.flush();
            cOut.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + name, e, authenticated, useBc);
        }
        String res = new String(bOut.toByteArray());
        if (!res.equals(lCode)) {
            this.fail("Failed - decrypted data doesn't match: " + name, authenticated, useBc);
        }
    }

    private static Key generateKey(String name) throws Exception {
        KeyGenerator kGen = name.indexOf(47) < 0 ? KeyGenerator.getInstance(name, "BC") : KeyGenerator.getInstance(name.substring(0, name.indexOf(47)), "BC");
        return kGen.generateKey();
    }

    @Override
    public void performTest() throws Exception {
        String[] blockCiphers64 = new String[]{"BLOWFISH", "DES", "DESEDE", "TEA", "CAST5", "RC2", "XTEA"};
        for (int i = 0; i != blockCiphers64.length; ++i) {
            this.testModes(blockCiphers64[i], new String[]{"/ECB/PKCS5Padding", "/CBC/PKCS5Padding", "/OFB/NoPadding", "/CFB/NoPadding", "/CTS/NoPadding"}, false);
            this.testModes(blockCiphers64[i], new String[]{"/EAX/NoPadding"}, true);
        }
        String[] blockCiphers128 = new String[]{"AES", "NOEKEON", "Twofish", "CAST6", "SEED", "Serpent", "RC6", "CAMELLIA"};
        for (int i = 0; i != blockCiphers128.length; ++i) {
            this.testModes(blockCiphers128[i], new String[]{"/ECB/PKCS5Padding", "/CBC/PKCS5Padding", "/OFB/NoPadding", "/CFB/NoPadding", "/CTS/NoPadding", "/CTR/NoPadding", "/SIC/NoPadding"}, false);
            this.testModes(blockCiphers128[i], new String[]{"/CCM/NoPadding", "/EAX/NoPadding", "/GCM/NoPadding", "/OCB/NoPadding"}, true);
        }
        String[] streamCiphers = new String[]{"ARC4", "SALSA20", "XSalsa20", "ChaCha", "Grainv1", "Grain128", "HC128", "HC256"};
        for (int i = 0; i != streamCiphers.length; ++i) {
            this.testModes(streamCiphers[i], new String[]{""}, false);
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        CipherStreamTest2.runTest(new CipherStreamTest2());
    }
}

