/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KDFParameters;

public class BrokenKDF2BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BrokenKDF2BytesGenerator(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for KDF2Generator");
        }
        KDFParameters p = (KDFParameters)param;
        this.shared = p.getSharedSecret();
        this.iv = p.getIV();
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new DataLengthException("output buffer too small");
        }
        long oBits = len * 8;
        if (oBits > (long)(this.digest.getDigestSize() * 8) * 29L) {
            new IllegalArgumentException("Output length to large");
        }
        int cThreshold = (int)(oBits / (long)this.digest.getDigestSize());
        byte[] dig = null;
        dig = new byte[this.digest.getDigestSize()];
        for (int counter = 1; counter <= cThreshold; ++counter) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update((byte)(counter & 0xFF));
            this.digest.update((byte)(counter >> 8 & 0xFF));
            this.digest.update((byte)(counter >> 16 & 0xFF));
            this.digest.update((byte)(counter >> 24 & 0xFF));
            this.digest.update(this.iv, 0, this.iv.length);
            this.digest.doFinal(dig, 0);
            if (len - outOff > dig.length) {
                System.arraycopy(dig, 0, out, outOff, dig.length);
                outOff += dig.length;
                continue;
            }
            System.arraycopy(dig, 0, out, outOff, len - outOff);
        }
        this.digest.reset();
        return len;
    }
}

