/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.ec;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.ec.ECPair;
import org.bouncycastle.crypto.ec.ECPairFactorTransform;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class ECFixedTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private BigInteger k;

    public ECFixedTransform(BigInteger k) {
        this.k = k;
    }

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("ECPublicKeyParameters are required for fixed transform.");
        }
        this.key = (ECPublicKeyParameters)param;
    }

    @Override
    public ECPair transform(ECPair cipherText) {
        if (this.key == null) {
            throw new IllegalStateException("ECFixedTransform not initialised");
        }
        ECPoint g = this.key.getParameters().getG();
        ECPoint gamma = g.multiply(this.k);
        ECPoint phi = this.key.getQ().multiply(this.k).add(cipherText.getY());
        return new ECPair(cipherText.getX().add(gamma).normalize(), phi.normalize());
    }

    @Override
    public BigInteger getTransformValue() {
        return this.k;
    }
}

